/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.format;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import org.pentaho.reporting.designer.core.editor.format.BorderSelection;
import org.pentaho.reporting.designer.core.editor.format.BorderSelectionEvent;
import org.pentaho.reporting.designer.core.editor.format.BorderSelectionListener;
import org.pentaho.reporting.designer.core.editor.format.BorderSelectionModel;
import org.pentaho.reporting.designer.core.editor.format.EditableStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.model.Border;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinitionFactory;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal.BorderRenderer;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public class BorderRenderPanel
extends JPanel {
    private static final StyleKey[] BORDER_KEYS = new StyleKey[]{ElementStyleKeys.BORDER_BOTTOM_COLOR, ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_HEIGHT, ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_WIDTH, ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_HEIGHT, ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_WIDTH, ElementStyleKeys.BORDER_BOTTOM_STYLE, ElementStyleKeys.BORDER_BOTTOM_WIDTH, ElementStyleKeys.BORDER_TOP_COLOR, ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_HEIGHT, ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_WIDTH, ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_HEIGHT, ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_WIDTH, ElementStyleKeys.BORDER_TOP_STYLE, ElementStyleKeys.BORDER_TOP_WIDTH, ElementStyleKeys.BORDER_LEFT_COLOR, ElementStyleKeys.BORDER_LEFT_STYLE, ElementStyleKeys.BORDER_LEFT_WIDTH, ElementStyleKeys.BORDER_RIGHT_COLOR, ElementStyleKeys.BORDER_RIGHT_STYLE, ElementStyleKeys.BORDER_RIGHT_WIDTH};
    private BorderRenderer borderRenderer;
    private ElementStyleSheet elementStyleSheet;
    private BoxDefinitionFactory boxDefinitionFactory;
    private BorderSelectionModel selectionModel;

    public BorderRenderPanel() {
        this.setBackground(Color.WHITE);
        this.addMouseListener(new MouseSelectionHandler());
        this.borderRenderer = new BorderRenderer();
        this.boxDefinitionFactory = new BoxDefinitionFactory();
        this.elementStyleSheet = new EditableStyleSheet();
        this.selectionModel = new BorderSelectionModel();
        this.selectionModel.addBorderSelectionListener(new SelectionUpdateHandler());
    }

    public ElementStyleSheet getElementStyleSheet() {
        return this.elementStyleSheet;
    }

    public void updateElementStyleSheet(ElementStyleSheet elementStyleSheet) {
        StyleKey styleKey;
        int i;
        StyleKey[] localKeys = this.elementStyleSheet.getDefinedPropertyNamesArray();
        for (i = 0; i < localKeys.length; ++i) {
            styleKey = localKeys[i];
            if (styleKey == null) continue;
            elementStyleSheet.setStyleProperty(styleKey, null);
        }
        for (i = 0; i < BORDER_KEYS.length; ++i) {
            styleKey = BORDER_KEYS[i];
            this.elementStyleSheet.setStyleProperty(styleKey, elementStyleSheet.getStyleProperty(styleKey));
        }
        this.repaint();
    }

    public BorderSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.clipRect(0, 0, this.getWidth(), this.getHeight());
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.elementStyleSheet == null) {
            g2.dispose();
            return;
        }
        int rightSelectorEdge = Math.max(80, this.getWidth() - 20);
        int bottomSelectorEdge = Math.max(80, this.getHeight() - 20);
        g2.setColor(Color.GREEN);
        if (this.getSelectionModel().isSelected(BorderSelection.TOP_LEFT)) {
            g2.fillRect(0, 0, 20, 20);
        }
        if (this.getSelectionModel().isSelected(BorderSelection.TOP)) {
            g2.fillRect(20, 0, rightSelectorEdge - 20, 20);
        }
        if (this.getSelectionModel().isSelected(BorderSelection.TOP_RIGHT)) {
            g2.fillRect(rightSelectorEdge, 0, 20, 20);
        }
        if (this.getSelectionModel().isSelected(BorderSelection.LEFT)) {
            g2.fillRect(0, 20, 20, bottomSelectorEdge - 20);
        }
        if (this.getSelectionModel().isSelected(BorderSelection.RIGHT)) {
            g2.fillRect(rightSelectorEdge, 20, 20, bottomSelectorEdge - 20);
        }
        if (this.getSelectionModel().isSelected(BorderSelection.BOTTOM_LEFT)) {
            g2.fillRect(0, bottomSelectorEdge, 20, 20);
        }
        if (this.getSelectionModel().isSelected(BorderSelection.BOTTOM)) {
            g2.fillRect(20, bottomSelectorEdge, rightSelectorEdge - 20, 20);
        }
        if (this.getSelectionModel().isSelected(BorderSelection.BOTTOM_RIGHT)) {
            g2.fillRect(rightSelectorEdge, bottomSelectorEdge, 20, 20);
        }
        StaticBoxLayoutProperties sblp = new StaticBoxLayoutProperties();
        BoxDefinition definition = this.boxDefinitionFactory.getBoxDefinition((StyleSheet)this.elementStyleSheet);
        Border border = definition.getBorder();
        sblp.setBorderTop(border.getTop().getWidth());
        sblp.setBorderLeft(border.getLeft().getWidth());
        sblp.setBorderBottom(border.getBottom().getWidth());
        sblp.setBorderRight(border.getRight().getWidth());
        this.borderRenderer.paintBackgroundAndBorder(sblp, definition, (StyleSheet)this.elementStyleSheet, StrictGeomUtility.toInternalValue((double)10.0), StrictGeomUtility.toInternalValue((double)10.0), StrictGeomUtility.toInternalValue((double)Math.max(80, this.getWidth() - 20)), StrictGeomUtility.toInternalValue((double)Math.max(80, this.getHeight() - 20)), g2);
        g2.setColor(Color.LIGHT_GRAY);
        g2.fillRect(25, 25, Math.max(50, this.getWidth() - 50), Math.max(50, this.getHeight() - 50));
        g2.drawLine(20, 0, 20, this.getHeight());
        g2.drawLine(0, 20, this.getWidth(), 20);
        g2.drawLine(rightSelectorEdge, 0, rightSelectorEdge, this.getHeight());
        g2.drawLine(0, bottomSelectorEdge, this.getWidth(), bottomSelectorEdge);
        g2.dispose();
    }

    public void commitValues(ElementStyleSheet styleSheet) {
        for (int i = 0; i < BORDER_KEYS.length; ++i) {
            StyleKey styleKey = BORDER_KEYS[i];
            styleSheet.setStyleProperty(styleKey, this.elementStyleSheet.getStyleProperty(styleKey));
        }
    }

    private class SelectionUpdateHandler
    implements BorderSelectionListener {
        private SelectionUpdateHandler() {
        }

        @Override
        public void selectionAdded(BorderSelectionEvent event) {
            BorderRenderPanel.this.repaint();
        }

        @Override
        public void selectionRemoved(BorderSelectionEvent event) {
            BorderRenderPanel.this.repaint();
        }
    }

    private class MouseSelectionHandler
    extends MouseAdapter {
        private MouseSelectionHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int x1 = e.getX();
            int y1 = e.getY();
            if (x1 <= 20) {
                if (y1 <= 20) {
                    this.invertSelection(BorderSelection.TOP_LEFT);
                } else if (y1 >= BorderRenderPanel.this.getHeight() - 20) {
                    this.invertSelection(BorderSelection.BOTTOM_LEFT);
                } else {
                    this.invertSelection(BorderSelection.LEFT);
                }
            } else if (x1 >= BorderRenderPanel.this.getWidth() - 20) {
                if (y1 <= 20) {
                    this.invertSelection(BorderSelection.TOP_RIGHT);
                } else if (y1 >= BorderRenderPanel.this.getHeight() - 20) {
                    this.invertSelection(BorderSelection.BOTTOM_RIGHT);
                } else {
                    this.invertSelection(BorderSelection.RIGHT);
                }
            } else if (y1 <= 20) {
                this.invertSelection(BorderSelection.TOP);
            } else if (y1 >= BorderRenderPanel.this.getHeight() - 20) {
                this.invertSelection(BorderSelection.BOTTOM);
            }
        }

        private void invertSelection(BorderSelection selection) {
            BorderSelectionModel model = BorderRenderPanel.this.getSelectionModel();
            if (model.isSelected(selection)) {
                model.removeSelection(selection);
            } else {
                model.addSelection(selection);
            }
        }
    }
}

