/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.expressions;

import java.util.Iterator;
import javax.swing.JComponent;
import org.pentaho.openformula.ui.FieldDefinition;
import org.pentaho.openformula.ui.FormulaEditorPanel;
import org.pentaho.openformula.ui.FunctionParameterEditor;
import org.pentaho.reporting.designer.core.ReportDesignerBoot;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.expressions.EditorExpressionsMessages;
import org.pentaho.reporting.designer.core.editor.expressions.ExpressionEditor;
import org.pentaho.reporting.designer.core.util.GUIUtils;
import org.pentaho.reporting.designer.core.util.ReportDesignerFunctionParameterEditor;
import org.pentaho.reporting.designer.core.util.table.CellEditorUtility;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.function.FormulaFunction;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class FormulaExpressionEditor
implements ExpressionEditor {
    private static final FieldDefinition[] EMPTY_FIELDS = new FieldDefinition[0];
    private FormulaEditorPanel editorPanel = new FormulaEditorPanel();
    private ReportDocumentContext renderContext;
    private FormulaExpression formulaExpression;
    private FormulaFunction formulaFunction;

    @Override
    public void initialize(Expression expression, ReportDesignerContext designerContext) {
        this.renderContext = designerContext.getActiveContext();
        if (expression instanceof FormulaExpression) {
            this.formulaExpression = (FormulaExpression)expression;
            this.editorPanel.setFormulaText(this.formulaExpression.getFormula());
        } else if (expression instanceof FormulaFunction) {
            this.formulaFunction = (FormulaFunction)expression;
            this.editorPanel.setFormulaText(this.formulaFunction.getFormula());
        }
        if (StringUtils.isEmpty((String)this.editorPanel.getFormulaText())) {
            this.editorPanel.setFormulaText("=");
        }
        this.editorPanel.setFields(this.getFields());
        Configuration configuration = ReportDesignerBoot.getInstance().getGlobalConfig();
        Iterator propertyKeys = configuration.findPropertyKeys("org.pentaho.reporting.designer.core.function-editor.");
        while (propertyKeys.hasNext()) {
            String key = (String)propertyKeys.next();
            String function = key.substring("org.pentaho.reporting.designer.core.function-editor.".length());
            String editor = configuration.getConfigProperty(key);
            FunctionParameterEditor fnEditor = (FunctionParameterEditor)ObjectUtilities.loadAndInstantiate((String)editor, GUIUtils.class, FunctionParameterEditor.class);
            if (fnEditor instanceof ReportDesignerFunctionParameterEditor) {
                ReportDesignerFunctionParameterEditor rfn = (ReportDesignerFunctionParameterEditor)fnEditor;
                rfn.setReportDesignerContext(designerContext);
            }
            this.editorPanel.setEditor(function, fnEditor);
        }
    }

    private ReportDocumentContext getRenderContext() {
        return this.renderContext;
    }

    private FieldDefinition[] getFields() {
        return CellEditorUtility.getFields(this.getRenderContext(), new String[0]);
    }

    @Override
    public JComponent getEditorComponent() {
        return this.editorPanel;
    }

    @Override
    public void stopEditing() {
        String formulaText = this.editorPanel.getFormulaText();
        if (StringUtils.isEmpty((String)formulaText, (boolean)true) || formulaText.trim().equals("=")) {
            formulaText = null;
        }
        if (this.formulaExpression != null) {
            this.formulaExpression.setFormula(formulaText);
        } else if (this.formulaFunction != null) {
            this.formulaFunction.setFormula(formulaText);
        }
    }

    @Override
    public String getTitle() {
        return EditorExpressionsMessages.getString("FormulaExpressionEditor.Formula");
    }
}

