/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown.parser;

import java.util.ArrayList;
import org.pentaho.reporting.designer.core.editor.drilldown.model.Parameter;
import org.pentaho.reporting.designer.core.editor.drilldown.model.ParameterDocument;
import org.pentaho.reporting.designer.core.editor.drilldown.model.ParameterGroup;
import org.pentaho.reporting.designer.core.editor.drilldown.parser.ParameterReadHandler;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ParameterDocumentReadHandler
extends AbstractXmlReadHandler {
    private ParameterDocument parameterDefinition;
    private ArrayList parameters = new ArrayList();

    protected void startParsing(Attributes attrs) throws SAXException {
        this.parameterDefinition = new ParameterDocument();
        this.parameterDefinition.setPromptNeeded("true".equals(attrs.getValue(this.getUri(), "is-prompt-needed")));
        this.parameterDefinition.setPaginate("true".equals(attrs.getValue(this.getUri(), "paginate")));
        this.parameterDefinition.setSubscribe("true".equals(attrs.getValue(this.getUri(), "subscribe")));
        this.parameterDefinition.setShowParameterUi("true".equals(attrs.getValue(this.getUri(), "show-parameter-ui")));
        this.parameterDefinition.setLayout(attrs.getValue(this.getUri(), "layout"));
        String autoSubmit = attrs.getValue(this.getUri(), "autoSubmit");
        if ("true".equals(autoSubmit)) {
            this.parameterDefinition.setAutoSubmit(Boolean.TRUE);
        } else if ("false".equals(autoSubmit)) {
            this.parameterDefinition.setAutoSubmit(Boolean.FALSE);
        } else {
            this.parameterDefinition.setAutoSubmit(null);
        }
        this.parameterDefinition.setAutoSubmitUI("true".equals(attrs.getValue(this.getUri(), "autoSubmitUI")));
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("errors".equals(tagName)) {
            return new IgnoreAnyChildReadHandler();
        }
        if ("parameter".equals(tagName)) {
            ParameterReadHandler readHandler = new ParameterReadHandler();
            this.parameters.add(readHandler);
            return readHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterGroup parameterGroup;
            ParameterReadHandler readHandler = (ParameterReadHandler)((Object)this.parameters.get(i));
            Parameter parameter = readHandler.getParameter();
            String parameterGroupName = parameter.getAttribute("parameter-group");
            if (StringUtils.isEmpty((String)parameterGroupName)) {
                parameterGroupName = "parameters";
            }
            if ((parameterGroup = this.parameterDefinition.getParameterGroup(parameterGroupName)) == null) {
                String parameterGroupLabel = parameter.getAttribute("parameter-group-label");
                parameterGroup = new ParameterGroup(parameterGroupName, parameterGroupLabel);
                this.parameterDefinition.addParameterGroup(parameterGroup);
            }
            parameterGroup.addParameter(parameter);
        }
    }

    public Object getObject() throws SAXException {
        return this.parameterDefinition;
    }
}

