/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.pentaho.reporting.designer.core.editor.drilldown.model.Parameter;
import org.pentaho.reporting.designer.core.editor.drilldown.model.ParameterGroup;

public class ParameterDocument {
    private boolean promptNeeded;
    private boolean paginate;
    private String layout = "vertical";
    private Boolean autoSubmit;
    private boolean showParameterUi;
    private LinkedHashMap<String, ParameterGroup> parameters = new LinkedHashMap();
    private boolean autoSubmitUI;
    private boolean subscribe;

    public boolean isShowParameterUi() {
        return this.showParameterUi;
    }

    public void setShowParameterUi(boolean showParameterUi) {
        this.showParameterUi = showParameterUi;
    }

    public boolean isPromptNeeded() {
        return this.promptNeeded;
    }

    public void setPromptNeeded(boolean promptNeeded) {
        this.promptNeeded = promptNeeded;
    }

    public boolean isPaginate() {
        return this.paginate;
    }

    public void setPaginate(boolean paginate) {
        this.paginate = paginate;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public ParameterGroup getParameterGroup(String name) {
        return this.parameters.get(name);
    }

    public void addParameterGroup(ParameterGroup parameterGroup) {
        if (parameterGroup == null) {
            throw new NullPointerException();
        }
        this.parameters.put(parameterGroup.getName(), parameterGroup);
    }

    public Parameter getParameter(String name) {
        Collection<ParameterGroup> parameterGroupCollection = this.parameters.values();
        for (ParameterGroup parameterGroup : parameterGroupCollection) {
            Parameter parameter = parameterGroup.getParameter(name);
            if (parameter == null) continue;
            return parameter;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public boolean isPaginationControlNeeded() {
        return !this.promptNeeded && this.paginate;
    }

    public Boolean getAutoSubmit() {
        return this.autoSubmit;
    }

    public void setAutoSubmit(Boolean autoSubmit) {
        this.autoSubmit = autoSubmit;
    }

    public boolean isAutoSubmitUI() {
        return this.autoSubmitUI;
    }

    public void setAutoSubmitUI(boolean autoSubmitUI) {
        this.autoSubmitUI = autoSubmitUI;
    }

    public boolean isSubscribe() {
        return this.subscribe;
    }

    public void setSubscribe(boolean subscribe) {
        this.subscribe = subscribe;
    }

    public ParameterGroup[] getParameterGroups() {
        return this.parameters.values().toArray(new ParameterGroup[this.parameters.size()]);
    }

    public Parameter[] getParameter() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        ParameterGroup[] groups = this.getParameterGroups();
        for (int i = 0; i < groups.length; ++i) {
            ParameterGroup group = groups[i];
            Parameter[] parameters1 = group.getParameters();
            for (int j = 0; j < parameters1.length; ++j) {
                parameters.add(parameters1[j]);
            }
        }
        return parameters.toArray(new Parameter[parameters.size()]);
    }
}

