/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterTable;
import org.pentaho.reporting.designer.core.editor.drilldown.basic.DrillDownModelWrapper;
import org.pentaho.reporting.designer.core.editor.drilldown.basic.XulDrillDownController;
import org.pentaho.reporting.designer.core.editor.drilldown.basic.XulDrillDownParameterTable;
import org.pentaho.reporting.designer.core.editor.drilldown.model.DrillDownModel;
import org.pentaho.reporting.designer.core.editor.drilldown.model.DrillDownParameter;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.dom.Document;

public class DefaultXulDrillDownController
implements XulDrillDownController {
    private String name;
    private XulDomContainer xulDomContainer;
    private DrillDownParameterTable table;
    private DrillDownModelWrapper wrapper;
    private ReportDesignerContext reportDesignerContext;

    protected DrillDownParameter[] filterParameter(DrillDownParameter[] parameter) {
        ArrayList<DrillDownParameter> list = new ArrayList<DrillDownParameter>(parameter.length);
        for (int i = 0; i < parameter.length; ++i) {
            DrillDownParameter downParameter = parameter[i];
            if (StringUtils.isEmpty((String)downParameter.getFormulaFragment())) continue;
            list.add(downParameter);
        }
        return list.toArray(new DrillDownParameter[list.size()]);
    }

    @Override
    public DrillDownModel getModel() {
        return this.wrapper.getModel();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public XulDomContainer getXulDomContainer() {
        return this.xulDomContainer;
    }

    public void setXulDomContainer(XulDomContainer xulDomContainer) {
        this.xulDomContainer = xulDomContainer;
    }

    public ReportDesignerContext getReportDesignerContext() {
        return this.reportDesignerContext;
    }

    @Override
    public void init(ReportDesignerContext reportDesignerContext, DrillDownModel model, String[] fields) {
        XulComponent tooltipAndTargetElement;
        XulComponent previewElement;
        XulComponent linkTooltipElement;
        XulComponent linkTargetElement;
        XulComponent configElement;
        if (model == null) {
            throw new NullPointerException();
        }
        if (reportDesignerContext == null) {
            throw new NullPointerException();
        }
        if (fields == null) {
            throw new NullPointerException();
        }
        this.reportDesignerContext = reportDesignerContext;
        Document doc = this.xulDomContainer.getDocumentRoot();
        DefaultBindingFactory bindingFactory = new DefaultBindingFactory();
        bindingFactory.setDocument(doc);
        bindingFactory.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.wrapper = new DrillDownModelWrapper(model);
        XulComponent pathElement = doc.getElementById("path");
        if (pathElement != null) {
            bindingFactory.createBinding((Object)this.wrapper, "drillDownPath", "path", "value", new BindingConvertor[0]);
        }
        if ((configElement = doc.getElementById("config")) != null) {
            bindingFactory.createBinding((Object)this.wrapper, "drillDownConfig", "config", "value", new BindingConvertor[0]);
        }
        if ((linkTargetElement = doc.getElementById("link-target")) != null) {
            bindingFactory.createBinding((Object)this.wrapper, "targetFormula", "link-target", "value", new BindingConvertor[0]);
        }
        if ((linkTooltipElement = doc.getElementById("link-tooltip")) != null) {
            bindingFactory.createBinding((Object)this.wrapper, "tooltipFormula", "link-tooltip", "value", new BindingConvertor[0]);
        }
        if ((previewElement = doc.getElementById("preview")) != null) {
            DefaultBindingFactory singleSourceBinding = new DefaultBindingFactory();
            singleSourceBinding.setBindingType(Binding.Type.ONE_WAY);
            singleSourceBinding.setDocument(doc);
            singleSourceBinding.createBinding((Object)this.wrapper, "preview", "preview", "value", new BindingConvertor[0]);
        }
        this.wrapper.refresh();
        XulComponent paramTableElement = doc.getElementById("parameter-table");
        if (paramTableElement instanceof XulDrillDownParameterTable) {
            XulDrillDownParameterTable parameterTable = (XulDrillDownParameterTable)paramTableElement;
            this.table = parameterTable.getTable();
            this.table.setExtraFields(fields);
            this.table.setReportDesignerContext(reportDesignerContext);
            this.table.setDrillDownParameter(model.getDrillDownParameter());
            this.table.setHideParameterUi(model.getDrillDownConfig().endsWith("-no-parameter"));
            this.table.addPropertyChangeListener("drillDownParameter", new TableModelBinding());
        }
        if (model.isLimitedEditor() && (tooltipAndTargetElement = doc.getElementById("tooltip-and-target-panel")) != null) {
            tooltipAndTargetElement.setVisible(false);
        }
        SwingUtilities.invokeLater(new RefreshParameterTask());
    }

    protected DrillDownModelWrapper getWrapper() {
        return this.wrapper;
    }

    public Object getData() {
        return this.getModel();
    }

    public void setData(Object data) {
    }

    protected DrillDownParameterTable getTable() {
        return this.table;
    }

    public void refresh() {
        this.getTable().refreshParameterData();
    }

    @Override
    public void deactivate() {
    }

    protected class RefreshParameterTask
    implements Runnable {
        @Override
        public void run() {
            DefaultXulDrillDownController.this.refresh();
        }
    }

    private class TableModelBinding
    implements PropertyChangeListener {
        private TableModelBinding() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DefaultXulDrillDownController.this.wrapper.setDrillDownParameter(DefaultXulDrillDownController.this.table.getDrillDownParameter());
        }
    }
}

