/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownSelector;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUiProfile;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUiProfileComparator;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUiProfileRegistry;

public class ButtonSelector
extends JPanel
implements DrillDownSelector {
    private EventListenerList eventListeners = new EventListenerList();
    private DrillDownUiProfile selectedItem;
    private HashMap<DrillDownUiProfile, JRadioButton> profilesToButton = new HashMap();

    public ButtonSelector() {
        ButtonGroup buttonGroup = new ButtonGroup();
        DrillDownUiProfileRegistry metaData = DrillDownUiProfileRegistry.getInstance();
        DrillDownUiProfile[] drilldownProfiles = metaData.getProfiles();
        Arrays.sort(drilldownProfiles, new DrillDownUiProfileComparator());
        for (int i = 0; i < drilldownProfiles.length; ++i) {
            DrillDownUiProfile profile = drilldownProfiles[i];
            JRadioButton button = new JRadioButton(profile.getDisplayName());
            button.addActionListener(new SelectorAction(profile));
            this.add(button);
            buttonGroup.add(button);
            this.profilesToButton.put(profile, button);
        }
        JRadioButton button = new JRadioButton("Manual Linking");
        button.addActionListener(new SelectorAction(null));
        this.add(button);
        buttonGroup.add(button);
        this.profilesToButton.put(null, button);
    }

    @Override
    public DrillDownUiProfile getSelectedProfile() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedProfile(DrillDownUiProfile profile) {
        this.selectedItem = profile;
        JRadioButton button = this.profilesToButton.get(this.selectedItem);
        if (button != null) {
            button.setSelected(true);
        }
        this.fireChangeEvent();
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            throw new NullPointerException();
        }
        this.eventListeners.add(ChangeListener.class, changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            throw new NullPointerException();
        }
        this.eventListeners.remove(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent() {
        ChangeListener[] changeListeners = (ChangeListener[])this.eventListeners.getListeners(ChangeListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < changeListeners.length; ++i) {
            ChangeListener listener = changeListeners[i];
            listener.stateChanged(event);
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    private class SelectorAction
    implements ActionListener {
        private DrillDownUiProfile profile;

        private SelectorAction(DrillDownUiProfile profile) {
            this.profile = profile;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ButtonSelector.this.setSelectedProfile(this.profile);
        }
    }
}

