/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.crosstab;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;

public class IndexedTransferable
implements Transferable {
    public static final DataFlavor ELEMENT_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref; class=" + TupleContainer.class.getName(), "Indexed Field List Transfer");
    public static final TupleContainer EMPTY = new TupleContainer(new UUID(0L, 0L), new FieldTuple[0]);
    private TupleContainer tupleContainer;

    public IndexedTransferable(UUID sourceId, List<FieldTuple> tuples) {
        this.tupleContainer = new TupleContainer(sourceId, tuples.toArray(new FieldTuple[tuples.size()]));
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{ELEMENT_FLAVOR};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return ELEMENT_FLAVOR.equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            return this.tupleContainer;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public static class TupleContainer
    implements Serializable {
        private FieldTuple[] tuples;
        private UUID sourceId;

        private TupleContainer(UUID sourceId, FieldTuple[] tuples) {
            this.sourceId = sourceId;
            this.tuples = tuples;
        }

        public FieldTuple[] getTuples() {
            return (FieldTuple[])this.tuples.clone();
        }

        public UUID getSourceId() {
            return this.sourceId;
        }
    }

    public static class FieldTuple
    implements Serializable {
        private int index;
        private String value;
        private String title;
        private Object raw;

        public FieldTuple(int index, String value) {
            this.index = index;
            this.value = value;
        }

        public FieldTuple(int index, String value, String title, Object raw) {
            this(index, value);
            this.title = title;
            this.raw = raw;
        }

        public String getTitle() {
            return this.title;
        }

        public Object getRaw() {
            return this.raw;
        }

        public int getIndex() {
            return this.index;
        }

        public String getValue() {
            return this.value;
        }
    }
}

