/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.crosstab;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.util.FastPropertyEditorManager;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTableModel;
import org.pentaho.reporting.designer.core.util.table.GroupedName;
import org.pentaho.reporting.designer.core.util.table.GroupingHeader;
import org.pentaho.reporting.designer.core.util.table.GroupingModel;
import org.pentaho.reporting.designer.core.util.table.TableStyle;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.metadata.StyleMetaData;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;

public class CrosstabOptionsTableModel
extends AbstractTableModel
implements ElementMetaDataTableModel,
GroupingModel {
    private ArrayList<CrosstabOption> backend = new ArrayList();
    private TableStyle tableStyle = TableStyle.GROUPED;

    public void addCrosstabOptionGroup(GroupingHeader header) {
        this.backend.add(new CrosstabOption(header));
        this.fireTableRowsInserted(this.backend.size() - 1, this.backend.size() - 1);
    }

    public void addAttributeOption(ElementType type, String nameSpace, String name, Object value) {
        ElementMetaData metaData = type.getMetaData();
        AttributeMetaData attributeDescription = metaData.getAttributeDescription(nameSpace, name);
        if (attributeDescription == null) {
            return;
        }
        String valueRole = attributeDescription.getValueRole();
        Class valueType = attributeDescription.getTargetType();
        PropertyEditor propertyEditor = attributeDescription.getEditor();
        GroupedName groupedName = new GroupedName((MetaData)attributeDescription);
        GroupingHeader groupingHeader = this.createGroupingHeader((MetaData)attributeDescription);
        this.backend.add(new CrosstabOption(groupingHeader, type, groupedName, valueType, valueRole, propertyEditor, value));
        this.fireTableRowsInserted(this.backend.size() - 1, this.backend.size() - 1);
    }

    public void addStyleOption(ElementType type, StyleKey styleKey, Object value) {
        ElementMetaData metaData = type.getMetaData();
        StyleMetaData styleDescription = metaData.getStyleDescription(styleKey);
        if (styleDescription == null) {
            return;
        }
        String valueRole = "Value";
        Class valueType = styleDescription.getTargetType();
        PropertyEditor propertyEditor = styleDescription.getEditor();
        GroupedName groupedName = new GroupedName((MetaData)styleDescription);
        GroupingHeader groupingHeader = this.createGroupingHeader((MetaData)styleDescription);
        this.backend.add(new CrosstabOption(groupingHeader, type, groupedName, valueType, "Value", propertyEditor, value));
        this.fireTableRowsInserted(this.backend.size() - 1, this.backend.size() - 1);
    }

    public void setStyleOption(ElementType type, StyleKey key, Object value) {
        String elementTypeName = type.getMetaData().getName();
        for (int i = 0; i < this.backend.size(); ++i) {
            StyleMetaData attributeMetaData;
            MetaData metaData;
            CrosstabOption crosstabOption = this.backend.get(i);
            if (crosstabOption.isHeaderRow() || !elementTypeName.equals(crosstabOption.getElementType().getMetaData().getName()) || !((metaData = crosstabOption.getMetaData()) instanceof StyleMetaData) || !key.equals((Object)(attributeMetaData = (StyleMetaData)metaData).getStyleKey())) continue;
            crosstabOption.setValue(value);
            this.fireTableCellUpdated(i, 1);
            return;
        }
    }

    public Object getStyleOption(ElementType type, StyleKey key) {
        String elementTypeName = type.getMetaData().getName();
        for (int i = 0; i < this.backend.size(); ++i) {
            StyleMetaData attributeMetaData;
            MetaData metaData;
            CrosstabOption crosstabOption = this.backend.get(i);
            if (crosstabOption.isHeaderRow() || !elementTypeName.equals(crosstabOption.getElementType().getMetaData().getName()) || !((metaData = crosstabOption.getMetaData()) instanceof StyleMetaData) || !key.equals((Object)(attributeMetaData = (StyleMetaData)metaData).getStyleKey())) continue;
            return crosstabOption.getValue();
        }
        return null;
    }

    public void setAttributeOption(ElementType type, String namespace, String name, Object value) {
        String elementTypeName = type.getMetaData().getName();
        for (int i = 0; i < this.backend.size(); ++i) {
            AttributeMetaData attributeMetaData;
            MetaData metaData;
            CrosstabOption crosstabOption = this.backend.get(i);
            if (crosstabOption.isHeaderRow() || !elementTypeName.equals(crosstabOption.getElementType().getMetaData().getName()) || !((metaData = crosstabOption.getMetaData()) instanceof AttributeMetaData) || !namespace.equals((attributeMetaData = (AttributeMetaData)metaData).getNameSpace()) || !name.equals(attributeMetaData.getName())) continue;
            crosstabOption.setValue(value);
            this.fireTableCellUpdated(i, 1);
            return;
        }
    }

    public Object getAttributeOption(ElementType type, String namespace, String name) {
        String elementTypeName = type.getMetaData().getName();
        for (int i = 0; i < this.backend.size(); ++i) {
            AttributeMetaData attributeMetaData;
            MetaData metaData;
            CrosstabOption crosstabOption = this.backend.get(i);
            if (crosstabOption.isHeaderRow() || !elementTypeName.equals(crosstabOption.getElementType().getMetaData().getName()) || !((metaData = crosstabOption.getMetaData()) instanceof AttributeMetaData) || !namespace.equals((attributeMetaData = (AttributeMetaData)metaData).getNameSpace()) || !name.equals(attributeMetaData.getName())) continue;
            return crosstabOption.getValue();
        }
        return null;
    }

    private GroupingHeader createGroupingHeader(MetaData metaData) {
        if (this.backend.isEmpty()) {
            GroupingHeader grHeader = new GroupingHeader(metaData.getGrouping(Locale.getDefault()));
            this.addCrosstabOptionGroup(grHeader);
            return grHeader;
        }
        CrosstabOption last = this.backend.get(this.backend.size() - 1);
        GroupingHeader groupingHeader = last.getGroupingHeader();
        String groupingText = metaData.getGrouping(Locale.getDefault());
        if (!groupingHeader.getHeaderText().equals(groupingText)) {
            GroupingHeader grHeader = new GroupingHeader(metaData.getGrouping(Locale.getDefault()));
            this.addCrosstabOptionGroup(grHeader);
            return grHeader;
        }
        return groupingHeader;
    }

    public void copyFrom(ReportElement e) {
        String elementTypeName = e.getElementType().getMetaData().getName();
        for (int i = 0; i < this.backend.size(); ++i) {
            MetaData metaData;
            CrosstabOption crosstabOption = this.backend.get(i);
            if (crosstabOption.isHeaderRow() || !elementTypeName.equals(crosstabOption.getElementType().getMetaData().getName()) || !((metaData = crosstabOption.getMetaData()) instanceof AttributeMetaData)) continue;
            AttributeMetaData attributeMetaData = (AttributeMetaData)metaData;
            Object value = e.getAttribute(attributeMetaData.getNameSpace(), attributeMetaData.getName());
            crosstabOption.setValue(value);
        }
        this.fireTableDataChanged();
    }

    public void copyInto(ReportElement e) {
        String elementTypeName = e.getElementType().getMetaData().getName();
        for (int i = 0; i < this.backend.size(); ++i) {
            MetaData metaData;
            CrosstabOption crosstabOption = this.backend.get(i);
            if (crosstabOption.isHeaderRow() || !elementTypeName.equals(crosstabOption.getElementType().getMetaData().getName()) || !((metaData = crosstabOption.getMetaData()) instanceof AttributeMetaData)) continue;
            AttributeMetaData attributeMetaData = (AttributeMetaData)metaData;
            e.setAttribute(attributeMetaData.getNameSpace(), attributeMetaData.getName(), crosstabOption.getValue());
        }
    }

    @Override
    public String getValueRole(int row, int column) {
        CrosstabOption crosstabOption = this.backend.get(row);
        return crosstabOption.getValueRole();
    }

    @Override
    public String[] getExtraFields(int row, int column) {
        return new String[0];
    }

    @Override
    public GroupingHeader getGroupHeader(int index) {
        CrosstabOption crosstabOption = this.backend.get(index);
        return crosstabOption.getGroupingHeader();
    }

    @Override
    public boolean isHeaderRow(int index) {
        CrosstabOption crosstabOption = this.backend.get(index);
        return crosstabOption.isHeaderRow();
    }

    public Class getClassForCell(int row, int col) {
        CrosstabOption crosstabOption = this.backend.get(row);
        if (crosstabOption.isHeaderRow()) {
            return crosstabOption.getType();
        }
        if (col == 0) {
            return GroupedName.class;
        }
        return crosstabOption.getType();
    }

    public PropertyEditor getEditorForCell(int row, int column) {
        if (column == 0) {
            return null;
        }
        CrosstabOption crosstabOption = this.backend.get(row);
        if (crosstabOption.isHeaderRow()) {
            return null;
        }
        PropertyEditor propertyEditor = crosstabOption.getPropertyEditor();
        if (propertyEditor != null) {
            return propertyEditor;
        }
        return this.getDefaultEditor(crosstabOption.getType());
    }

    @Override
    public void setTableStyle(TableStyle tableStyle) {
        this.tableStyle = tableStyle;
    }

    @Override
    public TableStyle getTableStyle() {
        return this.tableStyle;
    }

    @Override
    public int getRowCount() {
        return this.backend.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return Messages.getString("CrosstabOptionsTableModel.NameColumn", new Object[0]);
            }
            case 1: {
                return Messages.getString("CrosstabOptionsTableModel.ValueColumn", new Object[0]);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object getValueAt(int row, int column) {
        CrosstabOption crosstabOption = this.backend.get(row);
        if (crosstabOption.isHeaderRow()) {
            return crosstabOption.getGroupingHeader();
        }
        switch (column) {
            case 0: {
                return crosstabOption.getName();
            }
            case 1: {
                return crosstabOption.getValue();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex != 1) {
            return false;
        }
        CrosstabOption crosstabOption = this.backend.get(rowIndex);
        return !crosstabOption.isHeaderRow();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 1) {
            return;
        }
        CrosstabOption crosstabOption = this.backend.get(rowIndex);
        if (crosstabOption.isHeaderRow()) {
            return;
        }
        crosstabOption.setValue(aValue);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    protected PropertyEditor getDefaultEditor(Class type) {
        if (String.class.equals((Object)type)) {
            return null;
        }
        return FastPropertyEditorManager.findEditor(type);
    }

    private class CrosstabOption {
        private GroupingHeader groupingHeader;
        private boolean headerRow;
        private String valueRole;
        private Class type;
        private GroupedName name;
        private Object value;
        private PropertyEditor propertyEditor;
        private ElementType elementType;

        private CrosstabOption(GroupingHeader groupingHeader) {
            if (groupingHeader == null) {
                throw new NullPointerException();
            }
            this.groupingHeader = groupingHeader;
            this.headerRow = true;
            this.type = GroupingHeader.class;
        }

        private CrosstabOption(GroupingHeader groupingHeader, ElementType elementType, GroupedName name, Class type, String valueRole, PropertyEditor propertyEditor, Object value) {
            if (groupingHeader == null) {
                throw new NullPointerException();
            }
            if (name == null) {
                throw new NullPointerException();
            }
            if (type == null) {
                throw new NullPointerException();
            }
            if (valueRole == null) {
                throw new NullPointerException();
            }
            this.elementType = elementType;
            this.propertyEditor = propertyEditor;
            this.groupingHeader = groupingHeader;
            this.headerRow = false;
            this.name = name;
            this.type = type;
            this.valueRole = valueRole;
            this.value = value;
        }

        private ElementType getElementType() {
            return this.elementType;
        }

        public MetaData getMetaData() {
            return this.name.getMetaData();
        }

        private GroupedName getName() {
            return this.name;
        }

        private PropertyEditor getPropertyEditor() {
            return this.propertyEditor;
        }

        private Object getValue() {
            return this.value;
        }

        private Class getType() {
            return this.type;
        }

        private boolean isHeaderRow() {
            return this.headerRow;
        }

        private String getValueRole() {
            return this.valueRole;
        }

        private GroupingHeader getGroupingHeader() {
            return this.groupingHeader;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

