/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.crosstab;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.editor.crosstab.CrosstabEditSupport;
import org.pentaho.reporting.engine.classic.core.CrosstabCell;
import org.pentaho.reporting.engine.classic.core.CrosstabCellBody;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabHeader;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabSummaryHeader;
import org.pentaho.reporting.engine.classic.core.CrosstabTitleHeader;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.elementfactory.CrosstabBuilder;
import org.pentaho.reporting.engine.classic.core.elementfactory.CrosstabDetail;
import org.pentaho.reporting.engine.classic.core.elementfactory.CrosstabDimension;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.base.util.HashNMap;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class CrosstabEditorBuilder
extends CrosstabBuilder {
    private static final Log logger = LogFactory.getLog(CrosstabEditorBuilder.class);
    private final HashNMap<String, Tuple> predefinedGroups;
    private final CrosstabCellBody cellBody;
    private final LinkedHashMap<String, CrosstabEditSupport.DetailsDefinition> details;
    private Boolean detailsChanged;

    public CrosstabEditorBuilder(ContextAwareDataSchemaModel dataSchemaModel, CrosstabCellBody cellBody, LinkedHashMap<String, CrosstabEditSupport.DetailsDefinition> details) {
        super(dataSchemaModel);
        ArgumentNullException.validate((String)"cellBody", (Object)cellBody);
        ArgumentNullException.validate((String)"details", details);
        this.details = details;
        this.predefinedGroups = new HashNMap();
        this.cellBody = cellBody;
    }

    protected boolean isDetailsChanged() {
        if (this.detailsChanged != null) {
            return this.detailsChanged;
        }
        Iterator detailsFromBuilder = this.getDetails().iterator();
        Iterator<CrosstabEditSupport.DetailsDefinition> detailsFromPast = this.details.values().iterator();
        while (detailsFromBuilder.hasNext() && detailsFromPast.hasNext()) {
            CrosstabDetail detail;
            CrosstabDetail next = (CrosstabDetail)detailsFromBuilder.next();
            if (ObjectUtilities.equal((Object)next, (Object)(detail = detailsFromPast.next().createDetail()))) continue;
            logger.debug((Object)String.format("Details do not match up: [%s] vs [%s]", next, detail));
            this.detailsChanged = true;
            return true;
        }
        if (detailsFromBuilder.hasNext()) {
            logger.debug((Object)String.format("Detail count does not fit: More current details than past ones.", new Object[0]));
            this.detailsChanged = true;
            return true;
        }
        if (detailsFromPast.hasNext()) {
            logger.debug((Object)String.format("Detail count does not fit: More past details than current ones.", new Object[0]));
            this.detailsChanged = true;
            return true;
        }
        logger.debug((Object)String.format("Details have not changed. This is good, we can preserve the cells.", new Object[0]));
        this.detailsChanged = false;
        return false;
    }

    protected CrosstabOtherGroup createOtherGroup(GroupBody body, String column) {
        Tuple tuple = (Tuple)this.predefinedGroups.getLast((Object)column);
        Group other = tuple.getGroup();
        if (other instanceof CrosstabOtherGroup) {
            this.predefinedGroups.remove((Object)column, (Object)tuple);
            logger.debug((Object)String.format("Preserving existing other group " + column, new Object[0]));
            CrosstabOtherGroup g = (CrosstabOtherGroup)other.derive(true);
            g.setBody(body);
            return g;
        }
        return super.createOtherGroup(body, column);
    }

    protected CrosstabRowGroup createRowGroup(CrosstabCellBody cellBody, GroupBody innerBody, CrosstabDimension rowDimension) {
        String column = rowDimension.getField();
        Tuple tuple = (Tuple)this.predefinedGroups.getLast((Object)column);
        if (tuple == null) {
            return super.createRowGroup(cellBody, innerBody, rowDimension);
        }
        Group other = tuple.group;
        if (ObjectUtilities.equal((Object)tuple.dimension, (Object)rowDimension)) {
            if (other instanceof CrosstabRowGroup) {
                this.predefinedGroups.remove((Object)column, (Object)tuple);
                logger.debug((Object)String.format("Preserving existing row group " + column, new Object[0]));
                CrosstabRowGroup og = (CrosstabRowGroup)other.derive(true);
                og.setBody(innerBody);
                this.createSummaryCells(cellBody, rowDimension);
                return og;
            }
            if (other instanceof CrosstabColumnGroup) {
                this.predefinedGroups.remove((Object)column, (Object)tuple);
                logger.debug((Object)String.format("Mapping column group into row group " + column, new Object[0]));
                CrosstabColumnGroup oc = (CrosstabColumnGroup)other;
                CrosstabRowGroup cg = new CrosstabRowGroup(innerBody);
                cg.setHeader((CrosstabHeader)oc.getHeader().derive(true));
                cg.setTitleHeader((CrosstabTitleHeader)oc.getTitleHeader().derive(true));
                cg.setSummaryHeader((CrosstabSummaryHeader)oc.getSummaryHeader().derive(true));
                this.createSummaryCells(cellBody, rowDimension);
                return cg;
            }
        } else {
            logger.debug((Object)String.format("Dimension definition has changed on row dimension " + column, new Object[0]));
        }
        return super.createRowGroup(cellBody, innerBody, rowDimension);
    }

    protected CrosstabColumnGroup createColumnGroup(CrosstabCellBody cellBody, GroupBody innerBody, CrosstabDimension colDimension) {
        String column = colDimension.getField();
        Tuple tuple = (Tuple)this.predefinedGroups.getLast((Object)column);
        if (tuple == null) {
            return super.createColumnGroup(cellBody, innerBody, colDimension);
        }
        Group other = tuple.group;
        if (ObjectUtilities.equal((Object)tuple.dimension, (Object)colDimension)) {
            if (other instanceof CrosstabColumnGroup) {
                this.predefinedGroups.remove((Object)column, (Object)tuple);
                logger.debug((Object)String.format("Preserving existing column group " + column, new Object[0]));
                CrosstabColumnGroup og = (CrosstabColumnGroup)other.derive(true);
                og.setBody(innerBody);
                this.createSummaryCells(cellBody, colDimension);
                return og;
            }
            if (other instanceof CrosstabRowGroup) {
                this.predefinedGroups.remove((Object)column, (Object)tuple);
                logger.debug((Object)String.format("Mapping row group into column group " + column, new Object[0]));
                CrosstabRowGroup oc = (CrosstabRowGroup)other;
                CrosstabColumnGroup cg = new CrosstabColumnGroup(innerBody);
                cg.setHeader((CrosstabHeader)oc.getHeader().derive(true));
                cg.setTitleHeader((CrosstabTitleHeader)oc.getTitleHeader().derive(true));
                cg.setSummaryHeader((CrosstabSummaryHeader)oc.getSummaryHeader().derive(true));
                this.createSummaryCells(cellBody, colDimension);
                return cg;
            }
        } else {
            logger.debug((Object)String.format("Dimension definition has changed on column dimension " + column, new Object[0]));
        }
        return super.createColumnGroup(cellBody, innerBody, colDimension);
    }

    protected CrosstabCell createDetailsCell(String name, String rowDim, String colDim) {
        if (!this.isDetailsChanged()) {
            logger.debug((Object)String.format("Found existing details cell " + name, new Object[0]));
            CrosstabCell element = this.cellBody.findElement(rowDim, colDim);
            if (element != null) {
                return element;
            }
        }
        return super.createDetailsCell(name, rowDim, colDim);
    }

    protected CrosstabCellBody createCellBody() {
        if (!this.isDetailsChanged()) {
            return this.cellBody.derive(true);
        }
        return super.createCellBody();
    }

    public void addOtherDimension(CrosstabOtherGroup other) {
        this.addOtherDimension(other.getField());
        this.predefinedGroups.add((Object)other.getField(), (Object)new Tuple(new CrosstabDimension(other.getField()), (Group)other));
    }

    public void addRowDimension(CrosstabDimension dimension, CrosstabRowGroup rowGroup) {
        this.addRowDimension(dimension);
        this.predefinedGroups.add((Object)rowGroup.getField(), (Object)new Tuple(dimension.clone(), (Group)rowGroup));
    }

    public void addColumnDimension(CrosstabDimension dimension, CrosstabColumnGroup rowGroup) {
        this.addColumnDimension(dimension);
        this.predefinedGroups.add((Object)rowGroup.getField(), (Object)new Tuple(dimension.clone(), (Group)rowGroup));
        this.detailsChanged = null;
    }

    public CrosstabBuilder clearDimensions() {
        CrosstabBuilder crosstabBuilder = super.clearDimensions();
        this.detailsChanged = null;
        return crosstabBuilder;
    }

    private static class Tuple {
        private CrosstabDimension dimension;
        private Group group;

        private Tuple(CrosstabDimension dimension, Group group) {
            this.dimension = dimension;
            this.group = group;
        }

        public CrosstabDimension getDimension() {
            return this.dimension;
        }

        public Group getGroup() {
            return this.group;
        }
    }
}

