/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.crosstab;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.crosstab.CrosstabEditorBuilder;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.CrosstabCell;
import org.pentaho.reporting.engine.classic.core.CrosstabCellBody;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroup;
import org.pentaho.reporting.engine.classic.core.DetailsHeader;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupDataBody;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.SubGroupBody;
import org.pentaho.reporting.engine.classic.core.dom.AndMatcher;
import org.pentaho.reporting.engine.classic.core.dom.AttributeMatcher;
import org.pentaho.reporting.engine.classic.core.dom.ElementMatcher;
import org.pentaho.reporting.engine.classic.core.dom.MatcherContext;
import org.pentaho.reporting.engine.classic.core.dom.NodeMatcher;
import org.pentaho.reporting.engine.classic.core.dom.ReportStructureMatcher;
import org.pentaho.reporting.engine.classic.core.elementfactory.CrosstabBuilder;
import org.pentaho.reporting.engine.classic.core.elementfactory.CrosstabDetail;
import org.pentaho.reporting.engine.classic.core.elementfactory.CrosstabDimension;
import org.pentaho.reporting.engine.classic.core.filter.types.LabelType;
import org.pentaho.reporting.engine.classic.core.function.AggregationFunction;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;

public final class CrosstabEditSupport {
    private CrosstabEditSupport() {
    }

    public static GroupDataBody installCrosstabIntoLastGroup(RelationalGroup selectedGroup, CrosstabGroup newGroup) {
        GroupDataBody oldBody = (GroupDataBody)selectedGroup.getBody();
        selectedGroup.setBody((GroupBody)new SubGroupBody((Group)newGroup));
        return oldBody;
    }

    private static void populateOptions(LinkedHashMap<String, DetailsDefinition> cellBody, CrosstabBuilder builder) {
        builder.setMaximumHeight(null);
        builder.setMaximumWidth(null);
        builder.setPrefHeight(null);
        builder.setPrefWidth(null);
        builder.setMinimumHeight(new Float(-100.0f));
        builder.setMinimumWidth(new Float(-100.0f));
        Collection<DetailsDefinition> values = cellBody.values();
        Boolean allowMetaAttrs = null;
        Boolean allowMetaStyle = null;
        for (DetailsDefinition value : values) {
            Element detailElement = value.getDetailElement();
            if (detailElement == null) continue;
            if (allowMetaAttrs == null) {
                allowMetaAttrs = (Boolean)detailElement.getAttributeTyped("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-attributes", Boolean.class);
            }
            if (allowMetaStyle != null) continue;
            allowMetaStyle = (Boolean)detailElement.getAttributeTyped("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-styling", Boolean.class);
        }
        builder.setAllowMetaDataAttributes(allowMetaAttrs);
        builder.setAllowMetaDataStyling(allowMetaStyle);
    }

    public static CrosstabBuilder populateBuilder(CrosstabGroup editedGroup, ContextAwareDataSchemaModel reportDataSchemaModel) {
        CrosstabCellBody cellBody = null;
        Group group = editedGroup.getBody().getGroup();
        ArrayList<CrosstabRowGroup> rows = new ArrayList<CrosstabRowGroup>();
        ArrayList<CrosstabColumnGroup> cols = new ArrayList<CrosstabColumnGroup>();
        ArrayList<CrosstabOtherGroup> others = new ArrayList<CrosstabOtherGroup>();
        while (group != null) {
            if (group instanceof CrosstabOtherGroup) {
                CrosstabOtherGroup otherGroup = (CrosstabOtherGroup)group;
                others.add(otherGroup);
            } else if (group instanceof CrosstabRowGroup) {
                CrosstabRowGroup rowGroup = (CrosstabRowGroup)group;
                rows.add(rowGroup);
            } else {
                if (!(group instanceof CrosstabColumnGroup)) break;
                CrosstabColumnGroup colGroup = (CrosstabColumnGroup)group;
                cols.add(colGroup);
            }
            GroupBody body = group.getBody();
            if (body instanceof CrosstabCellBody) {
                cellBody = (CrosstabCellBody)body;
                break;
            }
            group = body.getGroup();
        }
        if (cellBody == null) {
            throw new IllegalStateException("A crosstab group can never be without a cell body");
        }
        CrosstabCell element = cellBody.findElement(null, null);
        LinkedHashMap<String, DetailsDefinition> details = element != null ? CrosstabEditSupport.extractFromDetailCell(element, cellBody.getHeader()) : new LinkedHashMap();
        CrosstabEditorBuilder builder = new CrosstabEditorBuilder(reportDataSchemaModel, cellBody, details);
        CrosstabEditSupport.populateOptions(details, builder);
        for (CrosstabOtherGroup other : others) {
            builder.addOtherDimension(other);
        }
        for (CrosstabRowGroup row : rows) {
            builder.addRowDimension(CrosstabEditSupport.extractFromRowGroup(row), row);
        }
        for (CrosstabColumnGroup col : cols) {
            builder.addColumnDimension(CrosstabEditSupport.extractFromColumnGroup(col), col);
        }
        for (DetailsDefinition value : details.values()) {
            builder.addDetails(value.createDetail());
        }
        return builder;
    }

    private static LinkedHashMap<String, DetailsDefinition> extractFromDetailCell(CrosstabCell cell, DetailsHeader header) {
        ReportElement[] elementsByAttribute = ReportStructureMatcher.findElementsByAttribute((ReportElement)cell, (String)"http://reporting.pentaho.org/namespaces/engine/attributes/core", (String)"field");
        LinkedHashMap<String, DetailsDefinition> d = new LinkedHashMap<String, DetailsDefinition>();
        for (ReportElement e : elementsByAttribute) {
            ReportElement[] labels;
            String field = (String)e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field");
            Class agg = (Class)e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "aggregation-type");
            if (agg != null && !AggregationFunction.class.isAssignableFrom(agg)) {
                agg = null;
            }
            Element label = (labels = ReportStructureMatcher.findElementsByAttribute((ReportElement)header, (String)"http://reporting.pentaho.org/namespaces/engine/attributes/wizard", (String)"label-for", (Object)field)).length > 0 ? (Element)labels[0] : null;
            d.put(field, new DetailsDefinition(label, (Element)e, field, agg));
        }
        return d;
    }

    private static CrosstabDimension extractFromRowGroup(CrosstabRowGroup rowGroup) {
        String title = CrosstabEditSupport.findTitle(rowGroup.getField(), (Band)rowGroup.getTitleHeader());
        String summaryTitle = CrosstabEditSupport.findTitle(rowGroup.getField(), (Band)rowGroup.getSummaryHeader());
        boolean summary = rowGroup.isPrintSummary();
        return new CrosstabDimension(rowGroup.getField(), title, summary, summaryTitle);
    }

    private static String findTitle(String field, Band titleHeader) {
        MatcherContext context = new MatcherContext();
        context.setMatchSubReportChilds(false);
        AndMatcher m = new AndMatcher((NodeMatcher)new ElementMatcher(LabelType.INSTANCE), (NodeMatcher)new AttributeMatcher("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "label-for", (Object)field));
        ReportElement match = ReportStructureMatcher.match((MatcherContext)context, (ReportElement)titleHeader, (NodeMatcher)m);
        if (match == null) {
            Element e;
            if (titleHeader.getElementCount() > 0 && (e = titleHeader.getElement(0)).getElementType() instanceof LabelType) {
                return (String)e.getAttributeTyped("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", String.class);
            }
            return null;
        }
        return (String)match.getAttributeTyped("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", String.class);
    }

    private static CrosstabDimension extractFromColumnGroup(CrosstabColumnGroup rowGroup) {
        String title = CrosstabEditSupport.findTitle(rowGroup.getField(), (Band)rowGroup.getTitleHeader());
        String summaryTitle = CrosstabEditSupport.findTitle(rowGroup.getField(), (Band)rowGroup.getSummaryHeader());
        boolean summary = rowGroup.isPrintSummary();
        return new CrosstabDimension(rowGroup.getField(), title, summary, summaryTitle);
    }

    public static class DetailsDefinition {
        private Element labelElement;
        private Element detailElement;
        private String field;
        private Class<AggregationFunction> aggregationFunction;

        private DetailsDefinition(Element labelElement, Element detailElement, String field, Class<AggregationFunction> aggregationFunction) {
            this.labelElement = labelElement;
            this.detailElement = detailElement;
            this.field = field;
            this.aggregationFunction = aggregationFunction;
        }

        public Element getLabelElement() {
            return this.labelElement;
        }

        public Element getDetailElement() {
            return this.detailElement;
        }

        public String getField() {
            return this.field;
        }

        public Class<AggregationFunction> getAggregationFunction() {
            return this.aggregationFunction;
        }

        public CrosstabDetail createDetail() {
            String label = (String)this.labelElement.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value");
            return new CrosstabDetail(this.field, label, this.aggregationFunction);
        }
    }

    public static class EditGroupOnGroupUndoEntry
    implements UndoEntry {
        private InstanceID target;
        private Group newRootGroup;
        private Group oldRootGroup;

        public EditGroupOnGroupUndoEntry(InstanceID target, Group oldRootGroup, Group newRootGroup) {
            ArgumentNullException.validate((String)"target", (Object)target);
            ArgumentNullException.validate((String)"oldRootGroup", (Object)oldRootGroup);
            ArgumentNullException.validate((String)"newRootGroup", (Object)newRootGroup);
            this.target = target;
            this.oldRootGroup = oldRootGroup.derive(true);
            this.newRootGroup = newRootGroup.derive(true);
        }

        @Override
        public void undo(ReportDocumentContext renderContext) {
            SubGroupBody bodyElement = (SubGroupBody)ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
            if (bodyElement == null) {
                throw new IllegalStateException("Expected to find a sub-group-body on the specified ID.");
            }
            bodyElement.setGroup(this.oldRootGroup.derive(true));
        }

        @Override
        public void redo(ReportDocumentContext renderContext) {
            SubGroupBody bodyElement = (SubGroupBody)ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
            if (bodyElement == null) {
                throw new IllegalStateException("Expected to find a sub-group-body on this report.");
            }
            bodyElement.setGroup(this.newRootGroup.derive(true));
        }

        @Override
        public UndoEntry merge(UndoEntry newEntry) {
            return null;
        }
    }

    public static class EditGroupOnReportUndoEntry
    implements UndoEntry {
        private static final long serialVersionUID = -6048384734272767240L;
        private Group newRootGroup;
        private Group oldRootGroup;

        public EditGroupOnReportUndoEntry(Group oldRootGroup, Group newRootGroup) {
            this.oldRootGroup = oldRootGroup.derive(true);
            this.newRootGroup = newRootGroup.derive(true);
        }

        @Override
        public void undo(ReportDocumentContext renderContext) {
            AbstractReportDefinition report = renderContext.getReportDefinition();
            report.setRootGroup(this.oldRootGroup.derive(true));
        }

        @Override
        public void redo(ReportDocumentContext renderContext) {
            AbstractReportDefinition report = renderContext.getReportDefinition();
            report.setRootGroup(this.newRootGroup.derive(true));
        }

        @Override
        public UndoEntry merge(UndoEntry newEntry) {
            return null;
        }
    }
}

