/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.crosstab;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.pentaho.reporting.designer.core.editor.crosstab.FieldDragSupport;
import org.pentaho.reporting.designer.core.editor.crosstab.IndexedTransferable;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;

public class CrosstabDialogTransferHandler
extends TransferHandler {
    private FieldDragSupport targetList;
    private boolean fieldPool;

    public CrosstabDialogTransferHandler(FieldDragSupport targetList) {
        this(targetList, false);
    }

    public CrosstabDialogTransferHandler(FieldDragSupport targetList, boolean fieldPool) {
        this.targetList = targetList;
        this.fieldPool = fieldPool;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!support.isDataFlavorSupported(IndexedTransferable.ELEMENT_FLAVOR)) {
            return false;
        }
        if (!support.isDrop()) {
            return false;
        }
        try {
            IndexedTransferable.TupleContainer items = this.extractFields(support.getTransferable());
            if (IndexedTransferable.EMPTY.equals(items)) {
                return false;
            }
            if (items.getSourceId().equals(this.targetList.getDragId())) {
                return false;
            }
            TransferHandler.DropLocation dropLocation = support.getDropLocation();
            this.targetList.insert(dropLocation, Arrays.asList(items.getTuples()), this.fieldPool);
            return true;
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
            return false;
        }
    }

    private IndexedTransferable.TupleContainer extractFields(Transferable t) throws IOException, UnsupportedFlavorException {
        Object transferData = t.getTransferData(IndexedTransferable.ELEMENT_FLAVOR);
        if (!(transferData instanceof IndexedTransferable.TupleContainer)) {
            return IndexedTransferable.EMPTY;
        }
        return (IndexedTransferable.TupleContainer)transferData;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDrop()) {
            return false;
        }
        if (support.isDataFlavorSupported(IndexedTransferable.ELEMENT_FLAVOR)) {
            try {
                IndexedTransferable.TupleContainer tc;
                Object transferData = support.getTransferable().getTransferData(IndexedTransferable.ELEMENT_FLAVOR);
                return !(transferData instanceof IndexedTransferable.TupleContainer) || !(tc = (IndexedTransferable.TupleContainer)transferData).getSourceId().equals(this.targetList.getDragId());
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public int getSourceActions(JComponent c) {
        if (this.fieldPool) {
            return 1;
        }
        return 2;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c != this.targetList) {
            throw new IllegalStateException();
        }
        List<IndexedTransferable.FieldTuple> selectedValues = this.targetList.getSelectedFields();
        return new IndexedTransferable(this.targetList.getDragId(), selectedValues);
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if ((action & 2) != 2) {
            return;
        }
        if (source != this.targetList) {
            throw new IllegalStateException();
        }
        try {
            IndexedTransferable.TupleContainer items = this.extractFields(data);
            this.targetList.removeValues(Arrays.asList(items.getTuples()));
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
    }
}

