/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.bundle;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.event.DocumentChangeHandler;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;

public class CreateBundleFileDialog
extends CommonDialog {
    private JComboBox mimeTypeBox;
    private JTextField fileNameField;
    private DocumentBundle bundle;

    public CreateBundleFileDialog(Dialog owner) throws HeadlessException {
        super(owner);
        ValidateHandler listener = new ValidateHandler();
        this.mimeTypeBox = new JComboBox();
        this.mimeTypeBox.setEditable(true);
        this.mimeTypeBox.addItem("text/plain");
        this.mimeTypeBox.addItem("text/xml");
        this.mimeTypeBox.addItem("application/octet-stream");
        this.mimeTypeBox.setSelectedIndex(0);
        this.mimeTypeBox.addActionListener(listener);
        this.fileNameField = new JTextField();
        this.fileNameField.getDocument().addDocumentListener((DocumentListener)((Object)listener));
        this.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.CreateBundleFile";
    }

    protected Component createContentPane() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)new JLabel(Messages.getString("CreateBundleFileDialog.EntryName", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel.add((Component)new JLabel(Messages.getString("CreateBundleFileDialog.ContentType", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        panel.add((Component)this.fileNameField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        panel.add((Component)this.mimeTypeBox, gbc);
        return panel;
    }

    public boolean performCreateEntry(DocumentBundle bundle) {
        this.bundle = bundle;
        this.mimeTypeBox.setSelectedIndex(0);
        this.fileNameField.setText("");
        LibSwingUtil.centerDialogInParent((Dialog)((Object)this));
        return super.performEdit();
    }

    public String getMimeType() {
        return (String)this.mimeTypeBox.getSelectedItem();
    }

    public String getFileName() {
        return this.fileNameField.getText();
    }

    private class ValidateHandler
    extends DocumentChangeHandler
    implements ActionListener {
        private ValidateHandler() {
        }

        protected void handleChange(DocumentEvent e) {
            String s = CreateBundleFileDialog.this.fileNameField.getText();
            if (StringUtils.isEmpty((String)s)) {
                CreateBundleFileDialog.this.getConfirmAction().setEnabled(false);
                return;
            }
            if (StringUtils.isEmpty((String)((String)CreateBundleFileDialog.this.mimeTypeBox.getSelectedItem()))) {
                CreateBundleFileDialog.this.getConfirmAction().setEnabled(false);
                return;
            }
            CreateBundleFileDialog.this.getConfirmAction().setEnabled(!CreateBundleFileDialog.this.bundle.isEntryExists(s));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.handleChange(null);
        }
    }
}

