/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.attributes;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.attributes.AbstractAttributeTableModel;
import org.pentaho.reporting.designer.core.util.table.GroupedName;
import org.pentaho.reporting.designer.core.util.table.GroupingHeader;
import org.pentaho.reporting.designer.core.util.table.GroupingModel;
import org.pentaho.reporting.designer.core.util.undo.AttributeEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.AttributeExpressionEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoManager;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class VisualAttributeTableModel
extends AbstractAttributeTableModel
implements GroupingModel {
    private static final Log logger = LogFactory.getLog(VisualAttributeTableModel.class);
    protected static final Object[] EMPTY_VALUES = new Object[0];
    protected static final Object NULL_INDICATOR = new Object();
    protected static final Element[] EMPTY_ELEMENTS = new Element[0];
    protected static final ElementType[] EMPTY_ELEMENT_TYPES = new ElementType[0];
    private static final String[] EMPTY_FIELDS = new String[0];
    private ExecutorService pool;

    public VisualAttributeTableModel() {
        this.setDataBackend(new AttributeDataBackend());
        this.pool = Executors.newSingleThreadExecutor();
    }

    public void setData(Element[] elements) {
        if (VisualAttributeTableModel.isSameElements((ReportElement[])elements, (ReportElement[])this.getData(), this.getElementTypes())) {
            SwingUtilities.invokeLater(new AbstractAttributeTableModel.SameElementsUpdateDataTask(this, this.getDataBackend()));
            return;
        }
        this.pool.submit(new AbstractAttributeTableModel.UpdateDataTask(this, (ReportElement[])elements));
    }

    @Override
    protected AbstractAttributeTableModel.DataBackend createDataBackend(GroupingHeader[] headers, AttributeMetaData[] metaData, ReportElement[] elements, ElementType[] elementTypes) {
        super.createDataBackend(headers, metaData, elements, elementTypes);
        return new AttributeDataBackend(metaData, headers, (Element[])elements, elementTypes);
    }

    @Override
    protected void refreshData() {
        this.pool.submit(new AbstractAttributeTableModel.UpdateDataTask(this, (ReportElement[])this.getAttributeDataBackend().getData()));
    }

    protected AttributeDataBackend getAttributeDataBackend() {
        return (AttributeDataBackend)this.getDataBackend();
    }

    public Element[] getData() {
        return this.getAttributeDataBackend().getData();
    }

    public ElementType[] getElementTypes() {
        return this.getAttributeDataBackend().getElementTypes();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return Messages.getString("VisualAttributeTableModel.NameColumn", new Object[0]);
            }
            case 1: {
                return Messages.getString("VisualAttributeTableModel.ValueColumn", new Object[0]);
            }
            case 2: {
                return Messages.getString("VisualAttributeTableModel.FormulaColumn", new Object[0]);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AttributeMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return this.getGroupings(rowIndex);
        }
        switch (columnIndex) {
            case 0: {
                return new GroupedName((MetaData)metaData);
            }
            case 1: {
                return this.computeFullValue(metaData, rowIndex);
            }
            case 2: {
                return this.computeExpressionValue(metaData, rowIndex);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        AttributeMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return false;
        }
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return !"ElementType".equals(metaData.getValueRole());
            }
            case 2: {
                if ("ElementType".equals(metaData.getValueRole())) {
                    return false;
                }
                return !metaData.isDesignTimeValue();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        AttributeMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                return;
            }
            case 1: {
                if (!this.defineFullValue(metaData, aValue)) break;
                AttributeDataBackend db = (AttributeDataBackend)this.getDataBackend();
                ((AttributeDataBackend)db).fullValues[rowIndex] = null;
                this.fireTableDataChanged();
                break;
            }
            case 2: {
                if (aValue != null && !(aValue instanceof Expression)) {
                    return;
                }
                if (!this.defineExpressionValue(metaData, (Expression)aValue)) break;
                AttributeDataBackend db = (AttributeDataBackend)this.getDataBackend();
                ((AttributeDataBackend)db).expressionValues[rowIndex] = null;
                this.fireTableDataChanged();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    private boolean defineFullValue(AttributeMetaData metaData, Object value) {
        if (value != null && !metaData.getTargetType().isInstance(value)) {
            logger.warn((Object)("Invalid type: " + value + " but expected " + metaData.getTargetType()));
            return false;
        }
        ReportDocumentContext reportRenderContext = this.getReportRenderContext();
        if (reportRenderContext == null) {
            throw new IllegalStateException("No report render context? Thats bad.");
        }
        UndoManager undo = reportRenderContext.getUndo();
        boolean changed = false;
        Element[] elements = this.getAttributeDataBackend().getData();
        ArrayList<AttributeEditUndoEntry> undos = new ArrayList<AttributeEditUndoEntry>();
        for (int i = 0; i < elements.length; ++i) {
            Element element = elements[i];
            Object attribute = element.getAttribute(metaData.getNameSpace(), metaData.getName());
            if (ObjectUtilities.equal((Object)attribute, (Object)value)) continue;
            undos.add(new AttributeEditUndoEntry(element.getObjectID(), metaData.getNameSpace(), metaData.getName(), attribute, value));
            element.setAttribute(metaData.getNameSpace(), metaData.getName(), value);
            changed = true;
        }
        undo.addChange(Messages.getString("VisualAttributeTableModel.UndoName", new Object[0]), new CompoundUndoEntry(undos.toArray(new UndoEntry[undos.size()])));
        return changed;
    }

    private Object computeFullValue(AttributeMetaData metaData, int row) {
        AttributeDataBackend dataBackend = this.getAttributeDataBackend();
        Object[] fullValues = dataBackend.getFullValues();
        Object o = fullValues[row];
        if (o == NULL_INDICATOR) {
            return null;
        }
        if (o != null) {
            return o;
        }
        Object lastElement = null;
        Element[] elements = dataBackend.getData();
        if (elements.length > 0) {
            Element element = elements[0];
            lastElement = element.getAttribute(metaData.getNameSpace(), metaData.getName());
        }
        fullValues[row] = lastElement != null ? lastElement : NULL_INDICATOR;
        return lastElement;
    }

    private boolean defineExpressionValue(AttributeMetaData metaData, Expression value) {
        boolean changed = false;
        Element[] elements = this.getAttributeDataBackend().getData();
        for (int i = 0; i < elements.length; ++i) {
            Element element = elements[i];
            Expression attribute = element.getAttributeExpression(metaData.getNameSpace(), metaData.getName());
            if (ObjectUtilities.equal((Object)attribute, (Object)value)) continue;
            changed = true;
        }
        if (changed) {
            ReportDocumentContext reportRenderContext = this.getReportRenderContext();
            if (reportRenderContext == null) {
                throw new IllegalStateException("No report render context? Thats bad.");
            }
            UndoManager undo = reportRenderContext.getUndo();
            ArrayList<AttributeExpressionEditUndoEntry> undos = new ArrayList<AttributeExpressionEditUndoEntry>();
            for (int i = 0; i < elements.length; ++i) {
                Element element = elements[i];
                Expression attribute = element.getAttributeExpression(metaData.getNameSpace(), metaData.getName());
                if (value != null) {
                    Expression expression = value.getInstance();
                    undos.add(new AttributeExpressionEditUndoEntry(element.getObjectID(), metaData.getNameSpace(), metaData.getName(), attribute, expression));
                    element.setAttributeExpression(metaData.getNameSpace(), metaData.getName(), expression);
                    continue;
                }
                undos.add(new AttributeExpressionEditUndoEntry(element.getObjectID(), metaData.getNameSpace(), metaData.getName(), attribute, null));
                element.setAttributeExpression(metaData.getNameSpace(), metaData.getName(), null);
            }
            undo.addChange(Messages.getString("VisualAttributeTableModel.UndoNameExpression", new Object[0]), new CompoundUndoEntry(undos.toArray(new UndoEntry[undos.size()])));
        }
        return changed;
    }

    private Expression computeExpressionValue(AttributeMetaData metaData, int row) {
        AttributeDataBackend dataBackend1 = this.getAttributeDataBackend();
        Object[] expressionValues = dataBackend1.getExpressionValues();
        Object o = expressionValues[row];
        if (o == NULL_INDICATOR) {
            return null;
        }
        if (o != null) {
            return (Expression)o;
        }
        if (metaData.isDesignTimeValue()) {
            expressionValues[row] = NULL_INDICATOR;
            return null;
        }
        Expression lastElement = null;
        Element[] elements = dataBackend1.getData();
        if (elements.length > 0) {
            Element element = elements[0];
            lastElement = element.getAttributeExpression(metaData.getNameSpace(), metaData.getName());
        }
        expressionValues[row] = lastElement != null ? lastElement : NULL_INDICATOR;
        return lastElement;
    }

    public Class getClassForCell(int rowIndex, int columnIndex) {
        AttributeMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return GroupingHeader.class;
        }
        switch (columnIndex) {
            case 0: {
                return GroupedName.class;
            }
            case 1: {
                return metaData.getTargetType();
            }
            case 2: {
                if (metaData.isDesignTimeValue()) {
                    return Object.class;
                }
                return Expression.class;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public PropertyEditor getEditorForCell(int rowIndex, int columnIndex) {
        AttributeMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return null;
            }
            case 1: {
                return this.computeEditor(metaData, rowIndex);
            }
            case 2: {
                return null;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    private PropertyEditor computeEditor(AttributeMetaData metaData, int row) {
        Object[] propertyEditors = this.getAttributeDataBackend().getPropertyEditors();
        Object o = propertyEditors[row];
        if (o == NULL_INDICATOR) {
            return null;
        }
        if (o != null) {
            return (PropertyEditor)o;
        }
        PropertyEditor propertyEditor = metaData.getEditor();
        if (propertyEditor == null) {
            propertyEditor = this.getDefaultEditor(metaData.getTargetType(), metaData.getValueRole());
        }
        propertyEditors[row] = propertyEditor == null ? NULL_INDICATOR : propertyEditor;
        return propertyEditor;
    }

    @Override
    public String getValueRole(int row, int column) {
        if (column != 1) {
            return null;
        }
        AttributeMetaData metaData = this.getMetaData(row);
        if (metaData == null) {
            return null;
        }
        return metaData.getValueRole();
    }

    @Override
    public String[] getExtraFields(int row, int column) {
        if (column == 0) {
            return EMPTY_FIELDS;
        }
        AttributeMetaData metaData = this.getMetaData(row);
        if (metaData == null) {
            return EMPTY_FIELDS;
        }
        return metaData.getExtraCalculationFields();
    }

    @Override
    public GroupingHeader getGroupHeader(int index) {
        return this.getGroupings(index);
    }

    @Override
    public boolean isHeaderRow(int index) {
        return this.getDataBackend().getMetaData(index) == null;
    }

    private static class AttributeDataBackend
    extends AbstractAttributeTableModel.DataBackend {
        private Element[] elements;
        private Object[] fullValues;
        private Object[] propertyEditors;
        private Object[] expressionValues;
        private ElementType[] elementTypes;

        private AttributeDataBackend() {
            this.elements = EMPTY_ELEMENTS;
            this.propertyEditors = EMPTY_VALUES;
            this.fullValues = EMPTY_VALUES;
            this.expressionValues = EMPTY_VALUES;
            this.elementTypes = EMPTY_ELEMENT_TYPES;
        }

        private AttributeDataBackend(AttributeMetaData[] metaData, GroupingHeader[] groupings, Element[] elements, ElementType[] elementTypes) {
            super(metaData, groupings);
            if (elements == null) {
                throw new NullPointerException();
            }
            if (elementTypes == null) {
                throw new NullPointerException();
            }
            this.elements = elements;
            this.fullValues = new Object[metaData.length];
            this.propertyEditors = new Object[metaData.length];
            this.expressionValues = new Object[metaData.length];
            this.elementTypes = elementTypes;
        }

        public Object[] getExpressionValues() {
            return this.expressionValues;
        }

        public Element[] getData() {
            return (Element[])this.elements.clone();
        }

        public Object[] getFullValues() {
            return this.fullValues;
        }

        @Override
        public void resetCache() {
            Arrays.fill(this.fullValues, null);
            Arrays.fill(this.expressionValues, null);
        }

        public Object[] getPropertyEditors() {
            return this.propertyEditors;
        }

        public ElementType[] getElementTypes() {
            return (ElementType[])this.elementTypes.clone();
        }
    }
}

