/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.attributes;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.FastPropertyEditorManager;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTableModel;
import org.pentaho.reporting.designer.core.util.table.GroupingHeader;
import org.pentaho.reporting.designer.core.util.table.ResourcePropertyEditor;
import org.pentaho.reporting.designer.core.util.table.TableStyle;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.GroupedMetaDataComparator;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.metadata.PlainMetaDataComparator;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;

public abstract class AbstractAttributeTableModel
extends AbstractTableModel
implements ElementMetaDataTableModel {
    protected static final GroupingHeader[] EMPTY_GROUPINGS = new GroupingHeader[0];
    protected static final AttributeMetaData[] EMPTY_METADATA = new AttributeMetaData[0];
    private DataBackend dataBackend;
    private DataBackend oldDataBackend;
    private TableStyle tableStyle = TableStyle.GROUPED;
    private ReportDocumentContext reportRenderContext;

    protected AbstractAttributeTableModel() {
    }

    @Override
    public int getRowCount() {
        return this.dataBackend.getRowCount();
    }

    protected AttributeMetaData getMetaData(int row) {
        return this.dataBackend.getMetaData(row);
    }

    protected GroupingHeader getGroupings(int row) {
        return this.dataBackend.getGroupings(row);
    }

    @Override
    public TableStyle getTableStyle() {
        return this.tableStyle;
    }

    @Override
    public void setTableStyle(TableStyle tableStyle) {
        if (tableStyle == null) {
            throw new NullPointerException();
        }
        this.tableStyle = tableStyle;
        this.refreshData();
    }

    protected abstract void refreshData();

    protected static boolean isSameElements(ReportElement[] elements, ReportElement[] existingElements, ElementType[] elementTypes) {
        if (elements.length != existingElements.length) {
            return false;
        }
        for (int i = 0; i < elements.length; ++i) {
            Element element = (Element)elements[i];
            if (existingElements[i].getObjectID() != element.getObjectID()) {
                return false;
            }
            if (elementTypes == null || element.getElementType().getClass().equals(elementTypes[i].getClass())) continue;
            return false;
        }
        return true;
    }

    public synchronized DataBackend getDataBackend() {
        return this.dataBackend;
    }

    public synchronized void setDataBackend(DataBackend dataBackend) {
        this.dataBackend = dataBackend;
    }

    protected DataBackend createDataBackend(GroupingHeader[] headers, AttributeMetaData[] metaData, ReportElement[] elements, ElementType[] elementTypes) {
        this.oldDataBackend = this.getDataBackend();
        return null;
    }

    protected DataBackend updateData(ReportElement[] elements) {
        AttributeMetaData[] metaData = AbstractAttributeTableModel.selectCommonAttributes(elements);
        ArrayList<ElementType> elementTypesArray = new ArrayList<ElementType>();
        for (int i = 0; i < elements.length; ++i) {
            Element element = (Element)elements[i];
            elementTypesArray.add(element.getElementType());
        }
        ElementType[] elementTypes = elementTypesArray.toArray(new ElementType[elementTypesArray.size()]);
        if (this.tableStyle == TableStyle.ASCENDING) {
            Arrays.sort(metaData, new PlainMetaDataComparator());
            return this.createDataBackend(new GroupingHeader[metaData.length], metaData, elements, elementTypes);
        }
        if (this.tableStyle == TableStyle.DESCENDING) {
            Arrays.sort(metaData, Collections.reverseOrder(new PlainMetaDataComparator()));
            return this.createDataBackend(new GroupingHeader[metaData.length], metaData, elements, elementTypes);
        }
        Arrays.sort(metaData, new GroupedMetaDataComparator());
        int groupCount = 0;
        int metaDataCount = 0;
        Locale locale = Locale.getDefault();
        if (metaData.length > 0) {
            String oldValue = null;
            for (int i = 0; i < metaData.length; ++i) {
                AttributeMetaData data = metaData[i];
                if (data.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)data)) continue;
                ++metaDataCount;
                if (groupCount == 0) {
                    groupCount = 1;
                    AttributeMetaData firstdata = metaData[i];
                    oldValue = firstdata.getGrouping(locale);
                    continue;
                }
                String grouping = data.getGrouping(locale);
                if (ObjectUtilities.equal(oldValue, (Object)grouping)) continue;
                oldValue = grouping;
                ++groupCount;
            }
        }
        AttributeMetaData[] groupedMetaData = new AttributeMetaData[metaDataCount + groupCount];
        int targetIdx = 0;
        GroupingHeader[] groupings = new GroupingHeader[groupedMetaData.length];
        GroupingHeader group = null;
        for (int sourceIdx = 0; sourceIdx < metaData.length; ++sourceIdx) {
            AttributeMetaData data = metaData[sourceIdx];
            if (data.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)data)) continue;
            if (targetIdx == 0) {
                groupings[targetIdx] = group = new GroupingHeader(data.getGrouping(locale));
                ++targetIdx;
            } else {
                String newgroup = data.getGrouping(locale);
                if (!ObjectUtilities.equal((Object)newgroup, (Object)group.getHeaderText())) {
                    groupings[targetIdx] = group = new GroupingHeader(newgroup);
                    ++targetIdx;
                }
            }
            groupings[targetIdx] = group;
            groupedMetaData[targetIdx] = data;
            ++targetIdx;
        }
        if (this.oldDataBackend != null) {
            groupings = this.reconcileState(groupings, this.oldDataBackend.getGroupings());
        }
        return this.createDataBackend(groupings, groupedMetaData, elements, elementTypes);
    }

    private GroupingHeader[] reconcileState(GroupingHeader[] groupings, GroupingHeader[] oldGroupings) {
        for (GroupingHeader header : groupings) {
            GroupingHeader oldHeader = this.findFirstOccuranceOfHeaderTitle(oldGroupings, header.getHeaderText());
            if (oldHeader == null) continue;
            header.setCollapsed(oldHeader.isCollapsed());
        }
        return groupings;
    }

    private GroupingHeader findFirstOccuranceOfHeaderTitle(GroupingHeader[] headerArray, String headerTitle) {
        for (GroupingHeader header : headerArray) {
            if (header == null || !ObjectUtilities.equal((Object)header.getHeaderText(), (Object)headerTitle)) continue;
            return header;
        }
        return null;
    }

    private static AttributeMetaData[] selectCommonAttributes(ReportElement[] elements) {
        String name;
        AttributeMap attributes = new AttributeMap();
        ArrayList<AttributeMetaData> selectedArrays = new ArrayList<AttributeMetaData>();
        for (int elementCount = 0; elementCount < elements.length; ++elementCount) {
            ReportElement element = elements[elementCount];
            AttributeMetaData[] datas = element.getMetaData().getAttributeDescriptions();
            for (int j = 0; j < datas.length; ++j) {
                Object attribute;
                AttributeMetaData data = datas[j];
                name = data.getName();
                String namespace = data.getNameSpace();
                if (data.isHidden()) {
                    attributes.setAttribute(namespace, name, (Object)Boolean.FALSE);
                    continue;
                }
                if (!WorkspaceSettings.getInstance().isVisible((MetaData)data) || Boolean.TRUE.equals(attribute = attributes.getAttribute(namespace, name)) || attribute != null) continue;
                if (elementCount == 0) {
                    attributes.setAttribute(namespace, name, (Object)Boolean.TRUE);
                    continue;
                }
                attributes.setAttribute(namespace, name, (Object)Boolean.FALSE);
            }
        }
        String[] namespaces = attributes.getNameSpaces();
        for (int nsIdx = 0; nsIdx < namespaces.length; ++nsIdx) {
            String namespace = namespaces[nsIdx];
            String[] names = attributes.getNames(namespace);
            for (int namesIdx = 0; namesIdx < names.length; ++namesIdx) {
                name = names[namesIdx];
                Object attribute = attributes.getAttribute(namespace, name);
                if (!Boolean.TRUE.equals(attribute)) continue;
                selectedArrays.add(AbstractAttributeTableModel.find(elements[0].getMetaData().getAttributeDescriptions(), namespace, name));
            }
        }
        return selectedArrays.toArray(new AttributeMetaData[selectedArrays.size()]);
    }

    private static AttributeMetaData find(AttributeMetaData[] data, String namespace, String name) {
        for (int i = 0; i < data.length; ++i) {
            AttributeMetaData attributeMetaData = data[i];
            if (!attributeMetaData.getName().equals(name) || !attributeMetaData.getNameSpace().equals(namespace)) continue;
            return attributeMetaData;
        }
        return null;
    }

    protected PropertyEditor getDefaultEditor(Class type, String valueRole) {
        if (String.class.equals((Object)type)) {
            return null;
        }
        if ("Resource".equals(valueRole)) {
            return new ResourcePropertyEditor(this.reportRenderContext);
        }
        return FastPropertyEditorManager.findEditor(type);
    }

    public ReportDocumentContext getReportRenderContext() {
        return this.reportRenderContext;
    }

    public void setReportRenderContext(ReportDocumentContext reportRenderContext) {
        this.reportRenderContext = reportRenderContext;
    }

    protected static abstract class DataBackend {
        private AttributeMetaData[] metaData;
        private GroupingHeader[] groupings;

        public DataBackend() {
            this.groupings = EMPTY_GROUPINGS;
            this.metaData = EMPTY_METADATA;
        }

        public abstract void resetCache();

        public DataBackend(AttributeMetaData[] metaData, GroupingHeader[] groupings) {
            this.metaData = metaData;
            this.groupings = groupings;
        }

        public int getRowCount() {
            return this.metaData.length;
        }

        protected AttributeMetaData getMetaData(int row) {
            return this.metaData[row];
        }

        protected GroupingHeader getGroupings(int row) {
            return this.groupings[row];
        }

        protected GroupingHeader[] getGroupings() {
            return this.groupings;
        }
    }

    protected class UpdateDataTask
    implements Runnable {
        private ReportElement[] elements;

        protected UpdateDataTask(ReportElement[] elements) {
            this.elements = (ReportElement[])elements.clone();
        }

        @Override
        public void run() {
            try {
                DataBackend dataBackend = AbstractAttributeTableModel.this.updateData(this.elements);
                if (SwingUtilities.isEventDispatchThread()) {
                    AbstractAttributeTableModel.this.setDataBackend(dataBackend);
                    AbstractAttributeTableModel.this.fireTableDataChanged();
                } else {
                    SwingUtilities.invokeAndWait(new NotifyChangeTask(dataBackend));
                }
            }
            catch (Exception e) {
                UncaughtExceptionsModel.getInstance().addException(e);
            }
        }
    }

    protected class SameElementsUpdateDataTask
    implements Runnable {
        private DataBackend dataBackend;

        protected SameElementsUpdateDataTask(DataBackend elements) {
            this.dataBackend = elements;
        }

        @Override
        public void run() {
            this.dataBackend.resetCache();
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    AbstractAttributeTableModel.this.setDataBackend(this.dataBackend);
                    AbstractAttributeTableModel.this.fireTableDataChanged();
                } else {
                    SwingUtilities.invokeAndWait(new NotifyChangeTask(this.dataBackend));
                }
            }
            catch (Exception e) {
                UncaughtExceptionsModel.getInstance().addException(e);
            }
        }
    }

    protected class NotifyChangeTask
    implements Runnable {
        private DataBackend dataBackend;

        protected NotifyChangeTask(DataBackend dataBackend) {
            this.dataBackend = dataBackend;
        }

        @Override
        public void run() {
            AbstractAttributeTableModel.this.setDataBackend(this.dataBackend);
            AbstractAttributeTableModel.this.fireTableDataChanged();
        }
    }
}

