/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.DesignerContextAction;
import org.pentaho.reporting.designer.core.actions.ToggleStateAction;
import org.pentaho.reporting.designer.core.actions.elements.SelectCrosstabBandAction;
import org.pentaho.reporting.designer.core.actions.elements.format.BoldAction;
import org.pentaho.reporting.designer.core.actions.elements.format.EditHyperlinkAction;
import org.pentaho.reporting.designer.core.actions.elements.format.FontColorSelectorComponent;
import org.pentaho.reporting.designer.core.actions.elements.format.FontFamilySelectorComponent;
import org.pentaho.reporting.designer.core.actions.elements.format.FontSizeSelectorComponent;
import org.pentaho.reporting.designer.core.actions.elements.format.ItalicsAction;
import org.pentaho.reporting.designer.core.actions.elements.format.TextAlignmentCenterAction;
import org.pentaho.reporting.designer.core.actions.elements.format.TextAlignmentJustifyAction;
import org.pentaho.reporting.designer.core.actions.elements.format.TextAlignmentLeftAction;
import org.pentaho.reporting.designer.core.actions.elements.format.TextAlignmentRightAction;
import org.pentaho.reporting.designer.core.actions.elements.format.UnderlineAction;
import org.pentaho.reporting.designer.core.actions.global.ShowPreviewPaneAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.editor.ZoomController;
import org.pentaho.reporting.designer.core.editor.ZoomModel;
import org.pentaho.reporting.designer.core.editor.preview.ReportPreviewComponent;
import org.pentaho.reporting.designer.core.editor.report.AbstractRenderComponent;
import org.pentaho.reporting.designer.core.editor.report.CrosstabRenderComponent;
import org.pentaho.reporting.designer.core.editor.report.ReportRenderEvent;
import org.pentaho.reporting.designer.core.editor.report.ReportRenderListener;
import org.pentaho.reporting.designer.core.editor.report.ResizeRootBandComponent;
import org.pentaho.reporting.designer.core.editor.report.RootBandRenderComponent;
import org.pentaho.reporting.designer.core.editor.report.RootBandRenderingModel;
import org.pentaho.reporting.designer.core.editor.report.layouting.AbstractElementRenderer;
import org.pentaho.reporting.designer.core.editor.report.layouting.CrosstabRenderer;
import org.pentaho.reporting.designer.core.editor.report.layouting.ElementRenderer;
import org.pentaho.reporting.designer.core.editor.report.layouting.RootBandRenderer;
import org.pentaho.reporting.designer.core.editor.report.lineal.AllVerticalLinealsComponent;
import org.pentaho.reporting.designer.core.editor.report.lineal.HorizontalLinealComponent;
import org.pentaho.reporting.designer.core.model.HorizontalPositionsModel;
import org.pentaho.reporting.designer.core.util.ActionToggleButton;
import org.pentaho.reporting.designer.core.util.CanvasImageLoader;
import org.pentaho.reporting.designer.core.util.Unit;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CrosstabElement;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;
import org.pentaho.reporting.libraries.designtime.swing.ToolbarButton;

public class ReportRendererComponent
extends JComponent {
    private ReportDocumentContext renderContext;
    private RootBandRenderingModel renderingModel;
    private HorizontalLinealComponent horizontalLinealComponent;
    private JPanel layoutRendererComponent;
    private ArrayList<AbstractRenderComponent> rootBandRenderers;
    private ReportDesignerContext designerContext;
    private boolean designVisible;
    private HorizontalPositionsModel horizontalPositionsModel;
    private CardLayout cardLayout;
    private ReportPreviewComponent previewComponent;
    private JComponent designView;
    private JComponent previewView;

    public ReportRendererComponent(ReportDesignerContext designerContext, ReportRenderContext renderContext) {
        if (renderContext == null) {
            throw new NullPointerException();
        }
        if (designerContext == null) {
            throw new NullPointerException();
        }
        this.designVisible = true;
        this.designerContext = designerContext;
        this.rootBandRenderers = new ArrayList();
        this.renderContext = renderContext;
        this.renderingModel = new RootBandRenderingModel(renderContext);
        this.renderingModel.addChangeListener(new RootBandModelUpdateHandler());
        this.renderingModel.addReportRenderListener(new LayoutUpdateHandler());
        this.horizontalPositionsModel = HorizontalPositionsModel.getHorizontalPositionsModel(renderContext);
        this.horizontalLinealComponent = new HorizontalLinealComponent(renderContext, false);
        this.layoutRendererComponent = new JPanel();
        this.layoutRendererComponent.setLayout(new BoxLayout(this.layoutRendererComponent, 1));
        this.layoutRendererComponent.setBackground(new Color(0, 0, 0, 0));
        this.layoutRendererComponent.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.layoutRendererComponent.setOpaque(false);
        this.cardLayout = new CardLayout();
        this.previewComponent = new ReportPreviewComponent(designerContext);
        this.getReport().addReportModelListener((ReportModelListener)new ReportPreviewChangeHandler());
        this.previewView = new ImagePanel(CanvasImageLoader.getInstance().getBackgroundImage().getImage());
        this.previewView.setLayout(new BorderLayout());
        this.previewView.add((Component)this.previewComponent, "Center");
        ZoomModel zoomModel = renderContext.getZoomModel();
        ZoomController zoomController = new ZoomController(zoomModel);
        AllVerticalLinealsComponent verticalLinealsComponent = new AllVerticalLinealsComponent(this.renderingModel);
        verticalLinealsComponent.setOpaque(false);
        verticalLinealsComponent.setBackground(new Color(0, 0, 0, 0));
        verticalLinealsComponent.setBorder(new EmptyBorder(0, 0, 0, 0));
        LayoutScrollable viewPortComponent = new LayoutScrollable();
        viewPortComponent.add((Component)this.layoutRendererComponent, "North");
        viewPortComponent.setBackground(new Color(0, 0, 0, 0));
        viewPortComponent.setBorder(new EmptyBorder(0, 0, 0, 0));
        viewPortComponent.setOpaque(false);
        NoKeysScrollPane reportScrollPane = new NoKeysScrollPane();
        reportScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        reportScrollPane.setVerticalScrollBarPolicy(20);
        reportScrollPane.setHorizontalScrollBarPolicy(30);
        reportScrollPane.setColumnHeaderView(this.horizontalLinealComponent);
        reportScrollPane.setCorner("UPPER_LEFT_CORNER", zoomController);
        reportScrollPane.setRowHeaderView(verticalLinealsComponent);
        reportScrollPane.setViewportView(viewPortComponent);
        reportScrollPane.setFocusTraversalKeysEnabled(false);
        reportScrollPane.setBackground(new Color(0, 0, 0, 0));
        reportScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        reportScrollPane.setOpaque(false);
        JViewport viewport = reportScrollPane.getViewport();
        viewport.setOpaque(false);
        viewPortComponent.setBackground(new Color(0, 0, 0, 0));
        viewPortComponent.setBorder(new EmptyBorder(0, 0, 0, 0));
        reportScrollPane.getRowHeader().setOpaque(false);
        ((JComponent)reportScrollPane.getRowHeader().getView()).setOpaque(false);
        reportScrollPane.getColumnHeader().setOpaque(false);
        ((JComponent)reportScrollPane.getColumnHeader().getView()).setOpaque(false);
        this.designView = new ImagePanel(CanvasImageLoader.getInstance().getBackgroundImage().getImage());
        this.designView.setLayout(new BorderLayout());
        this.designView.setOpaque(true);
        this.designView.add((Component)this.createToolbar(), "North");
        this.designView.add((Component)reportScrollPane, "Center");
        this.add((Component)this.designView, "design");
        this.add((Component)this.previewView, "preview");
        this.setLayout(this.cardLayout);
        this.showDesign();
        this.registerReport();
    }

    public boolean isDesignVisible() {
        return this.designVisible;
    }

    public void showPreview() {
        this.designVisible = false;
        this.previewView.setVisible(true);
        this.previewComponent.updatePreview(this.renderContext);
        this.designView.setVisible(false);
        this.cardLayout.last(this);
        this.repaint();
    }

    public void showDesign() {
        this.designVisible = true;
        this.previewView.setVisible(false);
        this.previewComponent.updatePreview(null);
        this.designView.setVisible(true);
        this.cardLayout.first(this);
        this.repaint();
    }

    public HorizontalPositionsModel getHorizontalPositionsModel() {
        return this.horizontalPositionsModel;
    }

    private JToolBar createToolbar() {
        ShowPreviewPaneAction previewAction = new ShowPreviewPaneAction();
        previewAction.setReportDesignerContext(this.designerContext);
        EditHyperlinkAction hyperlinkAction = new EditHyperlinkAction();
        hyperlinkAction.setReportDesignerContext(this.designerContext);
        FontFamilySelectorComponent familySelectorComponent = new FontFamilySelectorComponent();
        familySelectorComponent.setReportDesignerContext(this.designerContext);
        FontSizeSelectorComponent sizeSelectorComponent = new FontSizeSelectorComponent();
        sizeSelectorComponent.setReportDesignerContext(this.designerContext);
        FontColorSelectorComponent colorSelectorComponent = new FontColorSelectorComponent();
        colorSelectorComponent.setReportDesignerContext(this.designerContext);
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setOpaque(true);
        toolBar.add((Component)new ToolbarButton((Action)previewAction));
        toolBar.add(new JToolBar.Separator());
        toolBar.add((Component)((Object)familySelectorComponent));
        toolBar.add((Component)((Object)sizeSelectorComponent));
        toolBar.add(new JToolBar.Separator());
        toolBar.add(this.createButton(new BoldAction()));
        toolBar.add(this.createButton(new ItalicsAction()));
        toolBar.add(this.createButton(new UnderlineAction()));
        toolBar.add(new JToolBar.Separator());
        toolBar.add((Component)((Object)colorSelectorComponent));
        toolBar.add(new JToolBar.Separator());
        toolBar.add(this.createButton(new TextAlignmentLeftAction()));
        toolBar.add(this.createButton(new TextAlignmentCenterAction()));
        toolBar.add(this.createButton(new TextAlignmentRightAction()));
        toolBar.add(this.createButton(new TextAlignmentJustifyAction()));
        toolBar.add(new JToolBar.Separator());
        toolBar.add((Component)new ToolbarButton((Action)hyperlinkAction));
        if (this.getRenderContext().getReportDefinition() instanceof CrosstabElement) {
            SelectCrosstabBandAction selectCrosstabBandAction = new SelectCrosstabBandAction();
            selectCrosstabBandAction.setReportDesignerContext(this.designerContext);
            toolBar.add((Component)new ToolbarButton((Action)selectCrosstabBandAction));
            toolBar.add(new JToolBar.Separator());
        }
        return toolBar;
    }

    private JToggleButton createButton(DesignerContextAction action) {
        ActionToggleButton button = new ActionToggleButton();
        action.addPropertyChangeListener(new ActionSelectedHandler(button));
        action.setReportDesignerContext(this.designerContext);
        button.putClientProperty("hideActionText", Boolean.TRUE);
        button.setFocusable(false);
        button.setAction(action);
        return button;
    }

    public RootBandRenderingModel getRenderingModel() {
        return this.renderingModel;
    }

    public AbstractReportDefinition getReport() {
        return this.renderContext.getReportDefinition();
    }

    public void dispose() {
        for (int i = 0; i < this.rootBandRenderers.size(); ++i) {
            AbstractRenderComponent o = this.rootBandRenderers.get(i);
            o.dispose();
        }
        this.rootBandRenderers.clear();
        this.previewComponent.dispose();
    }

    protected void registerReport() {
        this.layoutRendererComponent.removeAll();
        for (int i = 0; i < this.rootBandRenderers.size(); ++i) {
            AbstractRenderComponent o = this.rootBandRenderers.get(i);
            o.dispose();
        }
        this.rootBandRenderers.clear();
        ElementRenderer[] allRenderers = this.renderingModel.getAllRenderers();
        for (int i = 0; i < allRenderers.length; ++i) {
            AbstractRenderComponent renderComponent;
            AbstractElementRenderer rootRenderer;
            ElementRenderer allRenderer = allRenderers[i];
            if (allRenderer instanceof RootBandRenderer) {
                rootRenderer = (RootBandRenderer)allRenderer;
                ReportDocumentContext context = rootRenderer.getReportRenderContext();
                AbstractReportDefinition reportDefinition = context.getReportDefinition();
                if (reportDefinition instanceof CrosstabElement) {
                    rootRenderer.setVisualHeight(Unit.INCH.getDotsPerUnit() * 1.5 * 2.0);
                }
                RootBandRenderComponent bandComponent = new RootBandRenderComponent(this.designerContext, this.renderContext, false);
                bandComponent.setShowTopBorder(false);
                bandComponent.setShowLeftBorder(false);
                bandComponent.installRenderer((RootBandRenderer)rootRenderer, this.horizontalLinealComponent.getLinealModel(), this.horizontalPositionsModel);
                renderComponent = bandComponent;
            } else if (allRenderer instanceof CrosstabRenderer) {
                rootRenderer = (CrosstabRenderer)allRenderer;
                rootRenderer.setVisualHeight(Unit.INCH.getDotsPerUnit() * 1.5 * 2.0);
                CrosstabRenderComponent bandComponent = new CrosstabRenderComponent(this.designerContext, this.renderContext);
                bandComponent.setShowTopBorder(false);
                bandComponent.setShowLeftBorder(false);
                bandComponent.installRenderer((CrosstabRenderer)rootRenderer, this.horizontalLinealComponent.getLinealModel(), this.horizontalPositionsModel);
                renderComponent = bandComponent;
            } else {
                renderComponent = null;
            }
            if (renderComponent == null) continue;
            JPanel renderWrapper = new JPanel(new GridBagLayout());
            renderWrapper.setOpaque(false);
            renderWrapper.setBackground(new Color(0, 0, 0, 0));
            renderWrapper.setBorder(new EmptyBorder(0, 0, 0, 0));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 1;
            renderWrapper.add((Component)renderComponent, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.fill = 1;
            renderWrapper.add((Component)new RightImageBorder(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.fill = 1;
            renderWrapper.add((Component)new ResizeRootBandComponent(true, allRenderer, this.renderContext), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.fill = 1;
            renderWrapper.add((Component)new RightImageBorder(), gbc);
            this.layoutRendererComponent.add(renderWrapper);
            this.rootBandRenderers.add(renderComponent);
        }
        this.layoutRendererComponent.add(new BottomImageBorder());
        this.revalidate();
        this.repaint();
    }

    public ReportDocumentContext getRenderContext() {
        return this.renderContext;
    }

    private class ActionSelectedHandler
    implements PropertyChangeListener {
        private JToggleButton button;

        public ActionSelectedHandler(JToggleButton aButton) {
            this.button = aButton;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            ToggleStateAction theAction = (ToggleStateAction)event.getSource();
            this.button.setSelected(theAction.isSelected());
        }
    }

    private static class NoKeysScrollPane
    extends JScrollPane {
        private NoKeysScrollPane() {
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
        }

        @Override
        public boolean keyDown(Event evt, int key) {
            return false;
        }

        @Override
        public boolean keyUp(Event evt, int key) {
            return false;
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            return false;
        }
    }

    private class ReportPreviewChangeHandler
    implements ReportModelListener {
        private ReportPreviewChangeHandler() {
        }

        public void nodeChanged(ReportModelEvent event) {
            if (!ReportRendererComponent.this.designVisible) {
                if (ReportRendererComponent.this.designerContext.getActiveContext() != ReportRendererComponent.this.renderContext) {
                    ReportRendererComponent.this.showDesign();
                } else {
                    ReportRendererComponent.this.previewComponent.updatePreview(ReportRendererComponent.this.renderContext);
                }
            }
        }
    }

    private class LayoutUpdateHandler
    implements ReportRenderListener {
        private LayoutUpdateHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutChanged(ReportRenderEvent event) {
            RootBandRenderingModel renderingModel = ReportRendererComponent.this.getRenderingModel();
            AbstractReportDefinition report = ReportRendererComponent.this.getReport();
            HorizontalPositionsModel horizontalPositionsModel = ReportRendererComponent.this.getHorizontalPositionsModel();
            ElementRenderer[] allRenderers = renderingModel.getAllRenderers();
            long age = report.getChangeTracker();
            boolean change = false;
            HorizontalPositionsModel horizontalPositionsModel2 = horizontalPositionsModel;
            synchronized (horizontalPositionsModel2) {
                for (int i = 0; i < allRenderers.length; ++i) {
                    ElementRenderer renderer = allRenderers[i];
                    long[] keys = renderer.getHorizontalEdgePositionKeys();
                    if (!horizontalPositionsModel.add(keys, age)) continue;
                    change = true;
                }
                if (horizontalPositionsModel.clear(age)) {
                    change = true;
                }
            }
            if (change) {
                horizontalPositionsModel.fireChangeEvent();
                for (int i = 0; i < ReportRendererComponent.this.rootBandRenderers.size(); ++i) {
                    AbstractRenderComponent component = (AbstractRenderComponent)ReportRendererComponent.this.rootBandRenderers.get(i);
                    component.repaint();
                }
            }
        }
    }

    private class RootBandModelUpdateHandler
    implements ChangeListener {
        private RootBandModelUpdateHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ReportRendererComponent.this.registerReport();
        }
    }

    private static class LayoutScrollable
    extends JPanel
    implements Scrollable {
        private LayoutScrollable() {
            this.setLayout(new BorderLayout());
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 20;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 100;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private static class ImagePanel
    extends JComponent {
        private Image img;

        public ImagePanel(Image img) {
            this.img = img;
            Dimension size = new Dimension(img.getWidth(null), img.getHeight(null));
            this.setPreferredSize(size);
            this.setMinimumSize(size);
            this.setMaximumSize(size);
            this.setSize(size);
            this.setLayout(null);
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.img, 0, 0, null);
        }
    }

    private static class BottomImageBorder
    extends JComponent {
        private ImageIcon bottomBorder;
        private ImageIcon bottomRightBorder;

        public BottomImageBorder() {
            this.setOpaque(false);
            this.setBackground(new Color(0, 0, 0, 0));
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.bottomBorder = CanvasImageLoader.getInstance().getBottomShadowImage();
            this.bottomRightBorder = CanvasImageLoader.getInstance().getRightCornerShadowImage();
            this.setMinimumSize(new Dimension(0, Math.max(this.bottomBorder.getIconHeight(), this.bottomRightBorder.getIconHeight())));
            this.setPreferredSize(new Dimension(0, Math.max(this.bottomBorder.getIconHeight(), this.bottomRightBorder.getIconHeight())));
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int cornerWidth = this.bottomRightBorder.getIconWidth();
            g.drawImage(this.bottomBorder.getImage(), 0, 0, this.getWidth() - cornerWidth, this.bottomBorder.getIconHeight(), this);
            g.drawImage(this.bottomRightBorder.getImage(), this.getWidth() - cornerWidth, 0, cornerWidth, this.bottomRightBorder.getIconHeight(), this);
        }
    }

    private static class RightImageBorder
    extends JComponent {
        public RightImageBorder() {
            this.setOpaque(false);
            this.setBackground(new Color(0, 0, 0, 0));
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            ImageIcon bottomRightBorder = CanvasImageLoader.getInstance().getRightCornerShadowImage();
            this.setMinimumSize(new Dimension(bottomRightBorder.getIconWidth(), 0));
            this.setPreferredSize(new Dimension(bottomRightBorder.getIconWidth(), 0));
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            ImageIcon rightBorder = CanvasImageLoader.getInstance().getRightShadowImage();
            g.drawImage(rightBorder.getImage(), 0, 0, rightBorder.getIconWidth(), this.getHeight(), this);
        }
    }
}

