/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.IconLoader;

public final class UndoAction
extends AbstractReportContextAction
implements ChangeListener {
    public UndoAction() {
        this.putValue("Name", ActionMessages.getString("UndoAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("UndoAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("UndoAction.Mnemonic"));
        this.putValue("SmallIcon", IconLoader.getInstance().getUndoIconSmall());
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("UndoAction.Accelerator"));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        this.setEnabled(activeContext.getUndo().isUndoPossible());
        if (this.isEnabled()) {
            this.putValue("ShortDescription", ActionMessages.getString("UndoAction.DescriptionPattern", activeContext.getUndo().getUndoName()));
        } else {
            this.putValue("ShortDescription", ActionMessages.getString("UndoAction.Description", new Object[0]));
        }
    }

    @Override
    protected void updateActiveContext(ReportDocumentContext oldContext, ReportDocumentContext newContext) {
        super.updateActiveContext(oldContext, newContext);
        if (oldContext != null) {
            oldContext.getUndo().removeUndoListener(this);
        }
        if (newContext != null) {
            newContext.getUndo().addUndoListener(this);
        }
        this.stateChanged(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        activeContext.getUndo().undo(activeContext);
        activeContext.getReportDefinition().notifyNodeStructureChanged();
    }
}

