/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriter;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.CommonFileChooser;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.FileChooserService;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;

public final class SaveReportUtilities {
    private static final Log logger = LogFactory.getLog(SaveReportUtilities.class);
    private static final String DEFAULT_EXTENSION = ".prpt";

    private SaveReportUtilities() {
    }

    public static File promptReportFilename(Component parent, File defaultFile) {
        FilesystemFilter filter = new FilesystemFilter(new String[]{DEFAULT_EXTENSION}, ActionMessages.getString("ReportBundleFileExtension.Description", new Object[0]), true);
        CommonFileChooser fileChooser = FileChooserService.getInstance().getFileChooser("report");
        fileChooser.setSelectedFile(defaultFile);
        fileChooser.setFilters(new FileFilter[]{filter});
        logger.debug((Object)"Prompting for save filename");
        if (!fileChooser.showDialog(parent, 1)) {
            logger.debug((Object)"Save filename - cancel option selected");
            return null;
        }
        File selectedFile = SaveReportUtilities.validateFileExtension(fileChooser.getSelectedFile(), parent);
        if (selectedFile == null) {
            return null;
        }
        if (selectedFile.exists()) {
            logger.debug((Object)("Selected file exists [" + selectedFile.getName() + "] - prompting for overwrite..."));
            int overwrite = JOptionPane.showConfirmDialog(parent, ActionMessages.getString("SaveReportUtilities.OverwriteDialog.Message", selectedFile.getAbsolutePath()), ActionMessages.getString("SaveReportUtilities.OverwriteDialog.Title", new Object[0]), 0);
            if (overwrite == 1) {
                return null;
            }
        }
        return selectedFile;
    }

    public static File validateFileExtension(File proposedFile, Component parent) {
        if (proposedFile == null) {
            return null;
        }
        String s = proposedFile.getName();
        if (s.endsWith(DEFAULT_EXTENSION) || s.endsWith(".prpti")) {
            return proposedFile;
        }
        String extension = IOUtils.getInstance().getFileExtension(s);
        if ("".equals(extension)) {
            File parentFile = proposedFile.getParentFile();
            if (parentFile == null) {
                return new File(IOUtils.getInstance().stripFileExtension(s) + DEFAULT_EXTENSION);
            }
            return new File(parentFile, IOUtils.getInstance().stripFileExtension(s) + DEFAULT_EXTENSION);
        }
        logger.debug((Object)"The selected filename does not have the standard extension - prompting the user to see if they want to change the extension");
        int result = JOptionPane.showConfirmDialog(parent, ActionMessages.getString("SaveReportUtilities.VerifyFileExtension.Message", proposedFile.getAbsolutePath()), ActionMessages.getString("SaveReportUtilities.VerifyFileExtension.Title", new Object[0]), 1);
        if (result == 2) {
            return null;
        }
        if (result == 1) {
            return proposedFile;
        }
        File validatedFile = new File(proposedFile.getParent(), IOUtils.getInstance().stripFileExtension(s) + DEFAULT_EXTENSION);
        logger.debug((Object)("User has selected YES - the filename has been changed to [" + validatedFile.getName() + "]"));
        return validatedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveReport(ReportDesignerContext context, ReportDocumentContext activeContext, File target) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        if (activeContext == null) {
            throw new IllegalArgumentException();
        }
        if (target == null) {
            throw new IllegalArgumentException();
        }
        try {
            logger.debug((Object)("Saving report in filename [" + target.getAbsolutePath() + "]"));
            BundleWriter.writeReportToZipFile((MasterReport)((MasterReport)activeContext.getContextRoot()), (File)target);
            context.getRecentFilesModel().addFile(target);
            boolean bl = true;
            return bl;
        }
        catch (Exception e1) {
            UncaughtExceptionsModel.getInstance().addException(new IOException(ActionMessages.getString("SaveReportUtilities.SaveFailed.Message", new Object[0]), e1));
            logger.error((Object)"Failed to save report", (Throwable)e1);
            boolean bl = false;
            return bl;
        }
        finally {
            activeContext.resetChangeTracker();
        }
    }

    public static File getCurrentFile(ResourceKey definitionSource) {
        while (definitionSource != null) {
            Object identifier = definitionSource.getIdentifier();
            if (identifier instanceof File) {
                return (File)identifier;
            }
            definitionSource = definitionSource.getParent();
        }
        return null;
    }
}

