/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.util.IconLoader;

public final class RedoAction
extends AbstractReportContextAction
implements ChangeListener {
    public RedoAction() {
        this.putValue("Name", ActionMessages.getString("RedoAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("RedoAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("RedoAction.Mnemonic"));
        this.putValue("SmallIcon", IconLoader.getInstance().getRedoIconSmall());
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("RedoAction.Accelerator"));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        this.setEnabled(activeContext.getUndo().isRedoPossible());
        if (this.isEnabled()) {
            this.putValue("ShortDescription", ActionMessages.getString("RedoAction.DescriptionPattern", activeContext.getUndo().getRedoName()));
        } else {
            this.putValue("ShortDescription", ActionMessages.getString("RedoAction.Description", new Object[0]));
        }
    }

    @Override
    protected void updateActiveContext(ReportRenderContext oldContext, ReportRenderContext newContext) {
        super.updateActiveContext(oldContext, newContext);
        if (oldContext != null) {
            oldContext.getUndo().removeUndoListener(this);
        }
        if (newContext != null) {
            newContext.getUndo().addUndoListener(this);
        }
        this.stateChanged(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        activeContext.getUndo().redo(activeContext);
        activeContext.getReportDefinition().notifyNodeStructureChanged();
    }
}

