/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.metadata.DocumentMetaDataDialog;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentMetaData;

public class EditReportPropertiesAction
extends AbstractReportContextAction {
    public EditReportPropertiesAction() {
        this.putValue("Name", ActionMessages.getString("EditReportPropertiesAction.Text", new Object[0]));
        this.putValue("Default", ActionMessages.getString("EditReportPropertiesAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("EditReportPropertiesAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("EditReportPropertiesAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        ReportDesignerContext context = this.getReportDesignerContext();
        Component parent = context.getView().getParent();
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        DocumentMetaDataDialog dialog = window instanceof JDialog ? new DocumentMetaDataDialog((JDialog)window) : (window instanceof JFrame ? new DocumentMetaDataDialog((JFrame)window) : new DocumentMetaDataDialog());
        try {
            MasterReport report = (MasterReport)activeContext.getContextRoot();
            DocumentBundle bundle = report.getBundle();
            DocumentMetaData oldMetaData = (DocumentMetaData)bundle.getMetaData().clone();
            DocumentMetaData result = dialog.performEdit(oldMetaData, report.getResourceManager(), report.getDefinitionSource());
            if (result == null) {
                return;
            }
            MetaDataEditUndoEntry undoEntry = new MetaDataEditUndoEntry(oldMetaData, result);
            undoEntry.redo(activeContext);
            activeContext.getUndo().addChange(ActionMessages.getString("EditReportPropertiesAction.Text", new Object[0]), undoEntry);
        }
        catch (CloneNotSupportedException cne) {
            UncaughtExceptionsModel.getInstance().addException(cne);
        }
    }

    private static class MetaDataEditUndoEntry
    implements UndoEntry {
        private DocumentMetaData oldMetaData;
        private DocumentMetaData newMetaData;

        private MetaDataEditUndoEntry(DocumentMetaData oldMetaData, DocumentMetaData newMetaData) {
            if (oldMetaData == null) {
                throw new NullPointerException();
            }
            if (newMetaData == null) {
                throw new NullPointerException();
            }
            this.oldMetaData = oldMetaData;
            this.newMetaData = newMetaData;
        }

        @Override
        public void undo(ReportDocumentContext renderContext) {
            MasterReport report = (MasterReport)renderContext.getContextRoot();
            WriteableDocumentBundle bundle = (WriteableDocumentBundle)report.getBundle();
            WriteableDocumentMetaData metaData = bundle.getWriteableDocumentMetaData();
            metaData.setBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "keywords", this.oldMetaData.getBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "keywords"));
            metaData.setBundleAttribute("http://purl.org/dc/elements/1.1/", "creator", this.oldMetaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "creator"));
            metaData.setBundleAttribute("http://purl.org/dc/elements/1.1/", "description", this.oldMetaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "description"));
            metaData.setBundleAttribute("http://purl.org/dc/elements/1.1/", "subject", this.oldMetaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "subject"));
            metaData.setBundleAttribute("http://purl.org/dc/elements/1.1/", "title", this.oldMetaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "title"));
            report.notifyNodePropertiesChanged();
        }

        @Override
        public void redo(ReportDocumentContext renderContext) {
            MasterReport report = (MasterReport)renderContext.getContextRoot();
            WriteableDocumentBundle bundle = (WriteableDocumentBundle)report.getBundle();
            WriteableDocumentMetaData metaData = bundle.getWriteableDocumentMetaData();
            metaData.setBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "keywords", this.newMetaData.getBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "keywords"));
            metaData.setBundleAttribute("http://purl.org/dc/elements/1.1/", "creator", this.newMetaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "creator"));
            metaData.setBundleAttribute("http://purl.org/dc/elements/1.1/", "description", this.newMetaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "description"));
            metaData.setBundleAttribute("http://purl.org/dc/elements/1.1/", "subject", this.newMetaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "subject"));
            metaData.setBundleAttribute("http://purl.org/dc/elements/1.1/", "title", this.newMetaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "title"));
            report.notifyNodePropertiesChanged();
        }

        @Override
        public UndoEntry merge(UndoEntry newEntry) {
            return null;
        }
    }
}

