/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.actions.report.CloseReportAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;

public class CloseChildReportsAction
extends AbstractReportContextAction {
    private int tabIndex;

    public CloseChildReportsAction() {
        this(-1);
    }

    public CloseChildReportsAction(int tabIndex) {
        this.tabIndex = tabIndex;
        this.putValue("Name", ActionMessages.getString("CloseChildReportsAction.Text", new Object[0]));
        this.putValue("Default", ActionMessages.getString("CloseChildReportsAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("CloseChildReportsAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("CloseChildReportsAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDesignerContext reportDesignerContext1 = this.getReportDesignerContext();
        if (this.tabIndex == -1) {
            ReportDocumentContext activeContext = this.getActiveContext();
            if (activeContext == null) {
                return;
            }
            this.performCloseReport(reportDesignerContext1, activeContext);
        } else if (this.tabIndex >= 0 && this.tabIndex < reportDesignerContext1.getReportRenderContextCount()) {
            ReportRenderContext context = reportDesignerContext1.getReportRenderContext(this.tabIndex);
            this.performCloseReport(reportDesignerContext1, context);
        }
    }

    private void performCloseReport(ReportDesignerContext context, ReportDocumentContext activeContext) {
        ReportRenderContext renderContext;
        int i;
        int contextCount = context.getReportRenderContextCount();
        ArrayList<ReportRenderContext> contexts = new ArrayList<ReportRenderContext>(contextCount);
        AbstractReportDefinition parentReportDefinition = activeContext.getReportDefinition();
        for (i = 0; i < contextCount; ++i) {
            renderContext = context.getReportRenderContext(i);
            AbstractReportDefinition childReportDefinition = renderContext.getReportDefinition();
            if (parentReportDefinition == childReportDefinition || !ModelUtility.isDescendant((Section)parentReportDefinition, (ReportElement)childReportDefinition)) continue;
            contexts.add(renderContext);
        }
        for (i = 0; i < contexts.size(); ++i) {
            renderContext = (ReportRenderContext)contexts.get(i);
            CloseReportAction.performUnconditionalClose(this.getReportDesignerContext(), renderContext);
        }
    }
}

