/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.Component;
import java.awt.event.ActionEvent;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.Anonymizer;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.types.LabelType;
import org.pentaho.reporting.engine.classic.core.filter.types.MessageType;
import org.pentaho.reporting.engine.classic.core.util.AbstractStructureVisitor;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.libraries.designtime.swing.background.BackgroundCancellableProcessHelper;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentMetaData;

public class AnonymizeReportAction
extends AbstractReportContextAction {
    public AnonymizeReportAction() {
        this.putValue("SmallIcon", IconLoader.getInstance().getLayoutBandsIcon());
        this.putValue("Name", ActionMessages.getString("AnonymizeReportAction.Text", new Object[0]));
        this.putValue("Default", ActionMessages.getString("AnonymizeReportAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("AnonymizeReportAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("AnonymizeReportAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        Thread thread = new Thread(new ConvertReportTask((MasterReport)this.getActiveContext().getContextRoot()));
        thread.setName("AnonymizeReport-Worker");
        thread.setDaemon(true);
        BackgroundCancellableProcessHelper.executeProcessWithCancelDialog((Thread)thread, null, (Component)this.getReportDesignerContext().getView().getParent(), (String)ActionMessages.getString("AnonymizeReportAction.TaskTitle", new Object[0]));
    }

    private static class ConvertReportTask
    extends AbstractStructureVisitor
    implements Runnable {
        private MasterReport report;
        private Anonymizer anonymizer;

        private ConvertReportTask(MasterReport report) {
            this.report = report;
            this.anonymizer = new Anonymizer();
        }

        @Override
        public void run() {
            try {
                super.inspect((AbstractReportDefinition)this.report);
                DocumentBundle bundle = this.report.getBundle();
                DocumentMetaData metaData = bundle.getMetaData();
                if (metaData instanceof WriteableDocumentMetaData) {
                    WriteableDocumentMetaData w = (WriteableDocumentMetaData)metaData;
                    w.setBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "keywords", null);
                    w.setBundleAttribute("http://purl.org/dc/elements/1.1/", "creator", null);
                    w.setBundleAttribute("http://purl.org/dc/elements/1.1/", "description", null);
                    w.setBundleAttribute("http://purl.org/dc/elements/1.1/", "subject", null);
                    w.setBundleAttribute("http://purl.org/dc/elements/1.1/", "title", null);
                }
            }
            catch (Exception e) {
                UncaughtExceptionsModel.getInstance().addException(e);
            }
        }

        protected void inspectElement(ReportElement element) {
            try {
                Object attribute;
                if (element.getElementType() instanceof LabelType) {
                    attribute = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value");
                    element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", this.anonymizer.anonymize(attribute));
                }
                if (element.getElementType() instanceof MessageType) {
                    attribute = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value");
                    element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", this.anonymizer.anonymizeMessage(attribute));
                }
            }
            catch (BeanException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

