/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.global;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.actions.ToggleStateAction;
import org.pentaho.reporting.designer.core.util.IconLoader;

public abstract class ZoomAction
extends AbstractReportContextAction
implements ToggleStateAction {
    private int percentage;

    protected ZoomAction(int percentage) {
        this.percentage = percentage;
        this.putValue("Name", ActionMessages.getString("ZoomAction.Text", percentage));
        this.putValue("ShortDescription", ActionMessages.getString("ZoomAction.Description", percentage));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("ZoomAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("ZoomAction.Accelerator"));
        if (percentage == 50) {
            this.putValue("SmallIcon", ZoomAction.createOverlayImageIcon(IconLoader.getInstance().getZoomIcon(), IconLoader.getInstance().getZoomOverlay50Icon()));
        } else if (percentage == 100) {
            this.putValue("SmallIcon", ZoomAction.createOverlayImageIcon(IconLoader.getInstance().getZoomIcon(), IconLoader.getInstance().getZoomOverlay100Icon()));
        } else if (percentage == 200) {
            this.putValue("SmallIcon", ZoomAction.createOverlayImageIcon(IconLoader.getInstance().getZoomIcon(), IconLoader.getInstance().getZoomOverlay200Icon()));
        } else if (percentage == 400) {
            this.putValue("SmallIcon", ZoomAction.createOverlayImageIcon(IconLoader.getInstance().getZoomIcon(), IconLoader.getInstance().getZoomOverlay400Icon()));
        } else {
            this.putValue("SmallIcon", IconLoader.getInstance().getZoomIcon());
        }
    }

    public static ImageIcon createOverlayImageIcon(ImageIcon ... imageIcons) {
        BufferedImage bi = new BufferedImage(imageIcons[0].getIconWidth(), imageIcons[0].getIconWidth(), 2);
        Graphics graphics = bi.getGraphics();
        for (ImageIcon imageIcon : imageIcons) {
            graphics.drawImage(imageIcon.getImage(), 0, 0, null);
        }
        return new ImageIcon(bi);
    }

    public int getPercentage() {
        return this.percentage;
    }
}

