/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.global;

import java.awt.AWTException;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.ReportDesignerBoot;
import org.pentaho.reporting.designer.core.actions.AbstractDesignerContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.libraries.base.util.PngEncoder;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class ScreenCaptureAction
extends AbstractDesignerContextAction {
    private static final Log logger = LogFactory.getLog(ScreenCaptureAction.class);
    private static final String PNG_SUFFIX = ".png";
    private static final String PREFIX = "prd-screen-capture-";
    private static boolean installed;

    public ScreenCaptureAction() {
        this.putValue("Name", ActionMessages.getString("ScreenCaptureAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("ScreenCaptureAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("ScreenCaptureAction.Mnemonic"));
        ScreenCaptureAction.installGlobally();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ScreenCaptureAction.saveScreenShot(e.getModifiers());
    }

    public static void installGlobally() {
        if (!installed) {
            installed = true;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(new GlobalKeyEventHandler());
        }
    }

    private static int getMenuKeyMask() {
        try {
            return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        }
        catch (UnsupportedOperationException he) {
            return 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveScreenShot(int modifiers) {
        Window component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        try {
            Robot robot = new Robot(graphicsDevice);
            BufferedImage image = (modifiers & 1) == 1 ? robot.createScreenCapture(graphicsConfiguration.getBounds()) : robot.createScreenCapture(component.getBounds());
            String homeDirectory = ReportDesignerBoot.getInstance().getGlobalConfig().getConfigProperty("user.home", ".");
            File homeDir = new File(homeDirectory);
            File f = ScreenCaptureAction.generateName(homeDir);
            if (f == null) {
                return;
            }
            try (FileOutputStream fout = new FileOutputStream(f);){
                PngEncoder encoder = new PngEncoder();
                encoder.setCompressionLevel(6);
                encoder.setEncodeAlpha(false);
                encoder.setImage((Image)image);
                byte[] bytes = encoder.pngEncode();
                fout.write(bytes);
            }
        }
        catch (IOException ioe) {
            UncaughtExceptionsModel.getInstance().addException(ioe);
        }
        catch (AWTException e1) {
            UncaughtExceptionsModel.getInstance().addException(e1);
        }
    }

    private static File generateName(File directory) {
        int i;
        File[] files = directory.listFiles(new ScreenShotFilenameFilter());
        int max = 0;
        for (i = 0; i < files.length; ++i) {
            try {
                File file = files[i];
                String name = file.getName().substring(PREFIX.length()).substring(PNG_SUFFIX.length());
                int idx = ParserUtil.parseInt((String)name, (int)-1);
                if (idx <= max) continue;
                max = idx;
                continue;
            }
            catch (Exception e) {
                logger.debug((Object)e);
            }
        }
        for (i = max + 1; i < 99999; ++i) {
            String nodeName = PREFIX + i + PNG_SUFFIX;
            File f = new File(directory, nodeName);
            if (f.exists()) continue;
            return f;
        }
        return null;
    }

    private static class GlobalKeyEventHandler
    implements KeyEventPostProcessor {
        private GlobalKeyEventHandler() {
        }

        @Override
        public boolean postProcessKeyEvent(KeyEvent e) {
            if (e.getID() == 401) {
                int menuKeyMask = ScreenCaptureAction.getMenuKeyMask();
                if (e.getKeyCode() == 80 && (e.getModifiers() & menuKeyMask) == menuKeyMask) {
                    ScreenCaptureAction.saveScreenShot(e.getModifiers());
                    return true;
                }
            }
            return false;
        }
    }

    private static class ScreenShotFilenameFilter
    implements FilenameFilter {
        private ScreenShotFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(ScreenCaptureAction.PREFIX) && name.endsWith(ScreenCaptureAction.PNG_SUFFIX);
        }
    }
}

