/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.global;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractDesignerContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.designtime.swing.ConsumableActionEvent;
import org.pentaho.reporting.libraries.designtime.swing.MacOSXIntegration;
import org.pentaho.reporting.libraries.designtime.swing.background.BackgroundCancellableProcessHelper;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.CommonFileChooser;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.FileChooserService;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.MemoryDocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public final class OpenReportAction
extends AbstractDesignerContextAction {
    public OpenReportAction() {
        this.putValue("Name", ActionMessages.getString("OpenReportAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("OpenReportAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("OpenReportAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("OpenReportAction.Accelerator"));
        this.putValue("SmallIcon", IconLoader.getInstance().getOpenIcon());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File[] selectedFiles;
        if (e.getSource() instanceof MacOSXIntegration.ApplicationEventSupport) {
            MacOSXIntegration.ApplicationEventSupport integration = (MacOSXIntegration.ApplicationEventSupport)e.getSource();
            String fileName = integration.getFileName();
            if (fileName != null) {
                SwingUtilities.invokeLater(new OpenReportTask(new File(fileName), this.getReportDesignerContext()));
            }
            if (e instanceof ConsumableActionEvent) {
                ConsumableActionEvent ce = (ConsumableActionEvent)e;
                ce.consume();
            }
            return;
        }
        FilesystemFilter filter = new FilesystemFilter(new String[]{".xml", ".report", ".prpt", ".prpti"}, ActionMessages.getString("OpenReportAction.FileTypeDescriptor", new Object[0]), true);
        CommonFileChooser fileChooser = FileChooserService.getInstance().getFileChooser("report");
        fileChooser.setFilters(new FileFilter[]{filter});
        fileChooser.setAllowMultiSelection(true);
        if (!fileChooser.showDialog(this.getReportDesignerContext().getView().getParent(), 0)) {
            return;
        }
        for (File selectedFile : selectedFiles = fileChooser.getSelectedFiles()) {
            SwingUtilities.invokeLater(new OpenReportTask(selectedFile, this.getReportDesignerContext()));
        }
    }

    public static void openReport(File selectedFile, ReportDesignerContext context) {
        if (selectedFile == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        LoadReportTask target = new LoadReportTask(selectedFile);
        Thread loadThread = new Thread(target);
        loadThread.setDaemon(true);
        BackgroundCancellableProcessHelper.executeProcessWithCancelDialog((Thread)loadThread, null, (Component)context.getView().getParent(), (String)ActionMessages.getString("OpenReportAction.LoadReportMessage", new Object[0]));
        AbstractReportDefinition report = target.getReport();
        if (report instanceof MasterReport) {
            try {
                context.addMasterReport((MasterReport)report);
                context.getRecentFilesModel().addFile(selectedFile);
                ReportDocumentContext activeContext = context.getActiveContext();
                if (activeContext != null) {
                    activeContext.resetChangeTracker();
                }
            }
            catch (ReportDataFactoryException e) {
                UncaughtExceptionsModel.getInstance().addException(e);
            }
        } else {
            Exception exception = target.getException();
            if (exception instanceof ResourceCreationException) {
                ExceptionDialog.showExceptionDialog((Component)context.getView().getParent(), (String)ActionMessages.getString("FailedToOpen.Error.Title", new Object[0]), (String)ActionMessages.getString("FailedToOpen.Error.Message", new Object[0]), (Exception)exception);
                UncaughtExceptionsModel.getInstance().addException(exception);
            } else if (exception != null) {
                UncaughtExceptionsModel.getInstance().addException(exception);
            }
        }
    }

    public static MasterReport loadReport(File selectedFile) throws ResourceException, IOException {
        ResourceManager resourceManager = new ResourceManager();
        MasterReport reportDefinition = OpenReportAction.loadReport(selectedFile, resourceManager);
        try {
            reportDefinition.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "report-save-path", (Object)selectedFile.getCanonicalPath());
        }
        catch (IOException ioe) {
            reportDefinition.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "report-save-path", (Object)selectedFile.getAbsolutePath());
        }
        return reportDefinition;
    }

    public static MasterReport loadReport(Object selectedFile, ResourceManager resourceManager) throws ResourceException, IOException {
        Resource directly = resourceManager.createDirectly(selectedFile, MasterReport.class);
        MasterReport resource = (MasterReport)directly.getResource();
        DocumentBundle bundle = resource.getBundle();
        if (bundle == null) {
            MemoryDocumentBundle documentBundle = new MemoryDocumentBundle(resource.getContentBase());
            documentBundle.getWriteableDocumentMetaData().setBundleType("application/vnd.pentaho.reporting.classic");
            resource.setBundle((DocumentBundle)documentBundle);
            resource.setContentBase(documentBundle.getBundleMainKey());
        } else {
            MemoryDocumentBundle mem = new MemoryDocumentBundle(resource.getContentBase());
            BundleUtilities.copyStickyInto((WriteableDocumentBundle)mem, (DocumentBundle)bundle);
            BundleUtilities.copyMetaData((MemoryDocumentBundle)mem, (DocumentBundle)bundle);
            resource.setBundle((DocumentBundle)mem);
            resource.setContentBase(mem.getBundleMainKey());
        }
        Object visible = resource.getBundle().getMetaData().getBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "visible");
        if ("true".equals(visible)) {
            resource.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/pentaho", "visible", (Object)Boolean.TRUE);
        } else if ("false".equals(visible)) {
            resource.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/pentaho", "visible", (Object)Boolean.FALSE);
        }
        return resource;
    }

    private static class LoadReportTask
    implements Runnable {
        private File file;
        private AbstractReportDefinition report;
        private Exception exception;

        private LoadReportTask(File file) {
            if (file == null) {
                throw new NullPointerException();
            }
            this.file = file;
        }

        @Override
        public void run() {
            try {
                this.report = OpenReportAction.loadReport(this.file);
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        public AbstractReportDefinition getReport() {
            return this.report;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public static class OpenReportTask
    implements Runnable {
        private File selectedFile;
        private ReportDesignerContext context;

        public OpenReportTask(File selectedFile, ReportDesignerContext context) {
            this.selectedFile = selectedFile;
            this.context = context;
        }

        @Override
        public void run() {
            OpenReportAction.openReport(this.selectedFile, this.context);
            this.context.getView().setWelcomeVisible(false);
        }
    }
}

