/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.global;

import java.awt.event.ActionEvent;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.ReportDesignerBoot;
import org.pentaho.reporting.designer.core.actions.AbstractDesignerContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.util.ExternalToolLauncher;
import org.pentaho.reporting.libraries.base.config.Configuration;

public final class LaunchHelpAction
extends AbstractDesignerContextAction {
    private static final Log log = LogFactory.getLog(LaunchHelpAction.class);

    public LaunchHelpAction() {
        this.putValue("Name", ActionMessages.getString("LaunchHelpAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("LaunchHelpAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("LaunchHelpAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("LaunchHelpAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Configuration config = ReportDesignerBoot.getInstance().getGlobalConfig();
        String docUrl = config.getConfigProperty("org.pentaho.reporting.designer.core.documentation.report_designer_user_guide");
        try {
            ExternalToolLauncher.openURL(docUrl);
        }
        catch (IOException ex) {
            log.warn((Object)("Could not load " + docUrl), (Throwable)ex);
        }
    }
}

