/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements.format;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.actions.ToggleStateAction;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.StyleEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.designtime.ReportModelEventFilter;
import org.pentaho.reporting.engine.classic.core.designtime.ReportModelEventFilterFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;

public final class ScaleAction
extends AbstractElementSelectionAction
implements ToggleStateAction {
    private ReportModelEventFilter eventFilter;

    public ScaleAction() {
        this.putValue("SwingSelectedKey", Boolean.FALSE);
        this.putValue("Name", ActionMessages.getString("ScaleAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("ScaleAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("ScaleAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("ScaleAction.Accelerator"));
        this.eventFilter = new ReportModelEventFilterFactory().createStyleFilter(ElementStyleKeys.SCALE);
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
        if (this.eventFilter.isFilteredEvent(event)) {
            this.updateSelection();
        }
    }

    @Override
    public boolean isSelected() {
        return Boolean.TRUE.equals(this.getValue("SwingSelectedKey"));
    }

    public void setSelected(boolean selected) {
        this.putValue("SwingSelectedKey", selected);
    }

    @Override
    protected void updateSelection() {
        super.updateSelection();
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        List<Element> visualElements = model.getSelectedElementsOfType(Element.class);
        if (visualElements.isEmpty()) {
            this.setSelected(false);
            return;
        }
        Element element = visualElements.get(0);
        ElementStyleSheet styleSheet = element.getStyle();
        this.setSelected(styleSheet.getBooleanStyleProperty(ElementStyleKeys.SCALE));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        List<Element> visualElements = model.getSelectedElementsOfType(Element.class);
        ArrayList<StyleEditUndoEntry> undos = new ArrayList<StyleEditUndoEntry>();
        Boolean value = null;
        for (Element element : visualElements) {
            ElementStyleSheet styleSheet = element.getStyle();
            if (value == null) {
                value = styleSheet.getBooleanStyleProperty(ElementStyleKeys.SCALE) ? Boolean.FALSE : Boolean.TRUE;
            }
            undos.add(StyleEditUndoEntry.createConditional((ReportElement)element, ElementStyleKeys.SCALE, value));
            styleSheet.setStyleProperty(ElementStyleKeys.SCALE, (Object)value);
        }
        this.getActiveContext().getUndo().addChange(ActionMessages.getString("ScaleAction.UndoName", new Object[0]), new CompoundUndoEntry(undos.toArray(new UndoEntry[undos.size()])));
    }
}

