/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements.format;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.drilldown.HyperlinkEditorDialog;
import org.pentaho.reporting.designer.core.editor.format.EditableStyleSheet;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.undo.ElementFormatUndoEntry;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class EditHyperlinkAction
extends AbstractElementSelectionAction {
    public EditHyperlinkAction() {
        this.putValue("SmallIcon", IconLoader.getInstance().getHyperlinkIcon());
        this.putValue("Name", ActionMessages.getString("EditHyperlinkAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("EditHyperlinkAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("EditHyperlinkAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("EditHyperlinkAction.Accelerator"));
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    protected void updateSelection() {
        if (!this.isSingleElementSelection()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.getSelectionModel().getSelectedElement(0) instanceof Element);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        List<Element> visualElements = model.getSelectedElementsOfType(Element.class);
        EditableStyleSheet styleSheet = EditableStyleSheet.create(visualElements);
        Component parent = this.getReportDesignerContext().getView().getParent();
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        HyperlinkEditorDialog dialog = this.createDialog(window);
        Map styleExpressions = visualElements.size() != 1 ? null : visualElements.get(0).getStyleExpressions();
        ElementFormatUndoEntry.EditResult result = dialog.performEdit(this.getReportDesignerContext(), styleSheet, styleExpressions);
        if (result == null) {
            return;
        }
        ElementFormatUndoEntry undoEntry = result.process(visualElements);
        this.getActiveContext().getUndo().addChange(ActionMessages.getString("EditHyperlinkAction.UndoName", new Object[0]), undoEntry);
    }

    protected HyperlinkEditorDialog createDialog(Window window) {
        HyperlinkEditorDialog dialog = window instanceof JDialog ? new HyperlinkEditorDialog((JDialog)window) : (window instanceof JFrame ? new HyperlinkEditorDialog((JFrame)window) : new HyperlinkEditorDialog());
        return dialog;
    }
}

