/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements.distribute;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.report.drag.MoveDragOperation;
import org.pentaho.reporting.designer.core.editor.report.snapping.EmptySnapModel;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.undo.MassElementStyleUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.MassElementStyleUndoEntryBuilder;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public final class DistributeMiddleAction
extends AbstractElementSelectionAction {
    public DistributeMiddleAction() {
        this.putValue("Name", ActionMessages.getString("DistributeMiddleAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("DistributeMiddleAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("DistributeMiddleAction.Mnemonic"));
        this.putValue("SmallIcon", IconLoader.getInstance().getDistributeMiddleIcon());
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("DistributeMiddleAction.Accelerator"));
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        List<Element> visualElements = model.getSelectedElementsOfType(Element.class);
        if (visualElements.size() <= 2) {
            return;
        }
        List<Element> reportElements = ModelUtility.filterParents(visualElements);
        if (reportElements.size() <= 2) {
            return;
        }
        Collections.sort(reportElements, new ElementPositionComparator());
        MassElementStyleUndoEntryBuilder builder = new MassElementStyleUndoEntryBuilder(reportElements);
        ArrayList<Element> carrier = new ArrayList<Element>(1);
        carrier.add(null);
        int lastElementIdx = reportElements.size() - 1;
        Element lastElement = reportElements.get(lastElementIdx);
        Element firstElement = reportElements.get(0);
        CachedLayoutData firstLayoutData = ModelUtility.getCachedLayoutData(firstElement);
        CachedLayoutData lastLayoutData = ModelUtility.getCachedLayoutData(lastElement);
        long height = lastLayoutData.getY() + lastLayoutData.getHeight() / 2L - (firstLayoutData.getY() + firstLayoutData.getHeight() / 2L);
        long incr = height / (long)lastElementIdx;
        long currentY = firstLayoutData.getY() + firstLayoutData.getHeight() / 2L;
        currentY += incr;
        for (Element reportElement : reportElements) {
            CachedLayoutData layoutData = ModelUtility.getCachedLayoutData(reportElement);
            long delta = currentY - layoutData.getHeight() / 2L;
            if (delta == 0L) continue;
            carrier.set(0, reportElement);
            Point2D.Double originPoint = new Point2D.Double(0.0, StrictGeomUtility.toExternalValue((long)layoutData.getY()));
            MoveDragOperation mop = new MoveDragOperation(carrier, originPoint, EmptySnapModel.INSTANCE, EmptySnapModel.INSTANCE);
            mop.update(new Point2D.Double(0.0, StrictGeomUtility.toExternalValue((long)delta)), 1.0);
            mop.finish();
            currentY += incr;
        }
        MassElementStyleUndoEntry massElementStyleUndoEntry = builder.finish();
        this.getActiveContext().getUndo().addChange(ActionMessages.getString("DistributeMiddleAction.UndoName", new Object[0]), massElementStyleUndoEntry);
    }

    private static class ElementPositionComparator
    implements Comparator<Element> {
        private ElementPositionComparator() {
        }

        @Override
        public int compare(Element o1, Element o2) {
            CachedLayoutData data2;
            long x2;
            CachedLayoutData data1 = ModelUtility.getCachedLayoutData(o1);
            long x1 = data1.getY();
            if (x1 < (x2 = (data2 = ModelUtility.getCachedLayoutData(o2)).getY())) {
                return -1;
            }
            if (x1 > x2) {
                return 1;
            }
            return 0;
        }
    }
}

