/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements.distribute;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.report.drag.MoveDragOperation;
import org.pentaho.reporting.designer.core.editor.report.snapping.EmptySnapModel;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.undo.MassElementStyleUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.MassElementStyleUndoEntryBuilder;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public final class DistributeHorizontalJustifyAction
extends AbstractElementSelectionAction {
    public DistributeHorizontalJustifyAction() {
        this.putValue("Name", ActionMessages.getString("DistributeHorizontalJustifyAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("DistributeHorizontalJustifyAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("DistributeHorizontalJustifyAction.Mnemonic"));
        this.putValue("SmallIcon", IconLoader.getInstance().getDistributeGapsHorizontalIcon());
        this.putValue("AcceleratorKey", ActionMessages.getString("DistributeHorizontalJustifyAction.Accelerator", new Object[0]));
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        List<Element> visualElements = model.getSelectedElementsOfType(Element.class);
        if (visualElements.size() <= 2) {
            return;
        }
        List<Element> reportElements = ModelUtility.filterParents(visualElements);
        if (reportElements.size() <= 2) {
            return;
        }
        Collections.sort(reportElements, new ElementPositionComparator());
        MassElementStyleUndoEntryBuilder builder = new MassElementStyleUndoEntryBuilder(reportElements);
        Element[] carrier = new Element[1];
        long totalHeight = 0L;
        long topmostY = Long.MAX_VALUE;
        long bottommostY = Long.MIN_VALUE;
        for (Element element : reportElements) {
            CachedLayoutData layoutData = ModelUtility.getCachedLayoutData(element);
            totalHeight += layoutData.getWidth();
            topmostY = Math.min(topmostY, layoutData.getX());
            bottommostY = Math.max(bottommostY, layoutData.getX() + layoutData.getWidth());
        }
        long gap = (bottommostY - topmostY - totalHeight) / (long)(reportElements.size() - 1);
        long currentY = topmostY;
        for (Element reportElement : reportElements) {
            CachedLayoutData layoutData = ModelUtility.getCachedLayoutData(reportElement);
            long height = layoutData.getWidth();
            carrier[0] = reportElement;
            Point2D.Double originPoint = new Point2D.Double(StrictGeomUtility.toExternalValue((long)layoutData.getX()), 0.0);
            MoveDragOperation mop = new MoveDragOperation(Arrays.asList(carrier), originPoint, EmptySnapModel.INSTANCE, EmptySnapModel.INSTANCE);
            mop.update(new Point2D.Double(StrictGeomUtility.toExternalValue((long)currentY), 0.0), 1.0);
            mop.finish();
            currentY += height + gap;
        }
        MassElementStyleUndoEntry massElementStyleUndoEntry = builder.finish();
        this.getActiveContext().getUndo().addChange(ActionMessages.getString("DistributeHorizontalJustifyAction.UndoName", new Object[0]), massElementStyleUndoEntry);
    }

    private static class ElementPositionComparator
    implements Comparator<Element> {
        private ElementPositionComparator() {
        }

        @Override
        public int compare(Element o1, Element o2) {
            CachedLayoutData data2;
            long x2;
            CachedLayoutData data1 = ModelUtility.getCachedLayoutData(o1);
            long x1 = data1.getX();
            if (x1 < (x2 = (data2 = ModelUtility.getCachedLayoutData(o2)).getX())) {
                return -1;
            }
            if (x1 > x2) {
                return 1;
            }
            return 0;
        }
    }
}

