/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements.align;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.List;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.report.drag.MoveDragOperation;
import org.pentaho.reporting.designer.core.editor.report.snapping.EmptySnapModel;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.undo.MassElementStyleUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.MassElementStyleUndoEntryBuilder;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public final class AlignTopAction
extends AbstractElementSelectionAction {
    private static final Point2D.Double ORIGIN_POINT = new Point2D.Double();

    public AlignTopAction() {
        this.putValue("Name", ActionMessages.getString("AlignTopAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("AlignTopAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("AlignTopAction.Mnemonic"));
        this.putValue("SmallIcon", IconLoader.getInstance().getAlignTopIcon());
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("AlignTopAction.Accelerator"));
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CachedLayoutData data;
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        List<Element> visualElements = model.getSelectedElementsOfType(Element.class);
        if (visualElements.size() <= 1) {
            return;
        }
        Element[] carrier = new Element[1];
        List<Element> objects = ModelUtility.filterParents(visualElements);
        long minY = Long.MAX_VALUE;
        MassElementStyleUndoEntryBuilder builder = new MassElementStyleUndoEntryBuilder(objects);
        for (Element object : objects) {
            data = ModelUtility.getCachedLayoutData(object);
            long y1 = data.getY();
            if (y1 >= minY) continue;
            minY = y1;
        }
        for (Element object : objects) {
            data = ModelUtility.getCachedLayoutData(object);
            long delta = minY - data.getY();
            if (delta == 0L) continue;
            carrier[0] = object;
            MoveDragOperation mop = new MoveDragOperation(Arrays.asList(carrier), ORIGIN_POINT, EmptySnapModel.INSTANCE, EmptySnapModel.INSTANCE);
            mop.update(new Point2D.Double(0.0, StrictGeomUtility.toExternalValue((long)delta)), 1.0);
            mop.finish();
        }
        MassElementStyleUndoEntry massElementStyleUndoEntry = builder.finish();
        this.getActiveContext().getUndo().addChange(ActionMessages.getString("AlignTopAction.UndoName", new Object[0]), massElementStyleUndoEntry);
    }
}

