/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.table.CreateTableDialog;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.ElementEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoManager;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.metadata.MaturityLevel;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TableLayout;
import org.pentaho.reporting.libraries.designtime.swing.FocusTracker;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class InsertTableAction
extends AbstractElementSelectionAction
implements SettingsListener {
    private static final long serialVersionUID = 4113715870254584033L;
    protected static final Float DEFAULT_WIDTH = new Float(100.0f);
    protected static final Float DEFAULT_HEIGHT = new Float(20.0f);
    private boolean expert;
    private MaturityLevel maturityLevel;
    private boolean deprecated;
    private FocusUpdateHandler focusTracker;

    public InsertTableAction() {
        this.putValue("Name", ActionMessages.getString("InsertTableAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("InsertTableAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("InsertTableAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("InsertTableAction.Accelerator"));
        this.setEnabled(false);
        this.maturityLevel = MaturityLevel.Snapshot;
        this.expert = true;
        this.deprecated = false;
        this.focusTracker = new FocusUpdateHandler();
        this.settingsChanged();
        WorkspaceSettings.getInstance().addSettingsListener(this);
    }

    @Override
    public void settingsChanged() {
        if (!WorkspaceSettings.getInstance().isShowExpertItems() && this.expert) {
            this.setVisible(false);
            return;
        }
        if (!WorkspaceSettings.getInstance().isShowDeprecatedItems() && this.deprecated) {
            this.setVisible(false);
            return;
        }
        if (!WorkspaceSettings.getInstance().isMatureFeature(this.maturityLevel)) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    protected void updateSelection() {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            this.setEnabled(false);
            return;
        }
        Object selectedElement = null;
        DocumentContextSelectionModel selectionModel1 = this.getSelectionModel();
        if (selectionModel1 == null) {
            this.setEnabled(false);
            return;
        }
        if (selectionModel1.getSelectionCount() > 0) {
            selectedElement = selectionModel1.getSelectedElement(0);
        }
        if (selectedElement instanceof Band) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object selectedElement = null;
        DocumentContextSelectionModel selectionModel1 = this.getSelectionModel();
        if (selectionModel1 == null) {
            return;
        }
        if (selectionModel1.getSelectionCount() > 0) {
            selectedElement = selectionModel1.getSelectedElement(0);
        }
        if (!(selectedElement instanceof Band)) {
            return;
        }
        Band band = (Band)selectedElement;
        ReportDesignerContext context = this.getReportDesignerContext();
        Component parent = context.getView().getParent();
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        CreateTableDialog dialog = window instanceof JDialog ? new CreateTableDialog((JDialog)window) : (window instanceof JFrame ? new CreateTableDialog((JFrame)window) : new CreateTableDialog());
        if (!dialog.createTable()) {
            return;
        }
        try {
            Band visualElement = InsertTableAction.createTable(dialog.getColumns(), dialog.getHeaderRows(), dialog.getDataRows());
            ElementStyleSheet styleSheet = visualElement.getStyle();
            styleSheet.setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)DEFAULT_WIDTH);
            styleSheet.setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)DEFAULT_HEIGHT);
            ReportDocumentContext activeContext = this.getActiveContext();
            UndoManager undo = activeContext.getUndo();
            undo.addChange(ActionMessages.getString("InsertTableAction.UndoName", new Object[0]), new ElementEditUndoEntry(band.getObjectID(), band.getElementCount(), null, (Element)visualElement));
            band.addElement((Element)visualElement);
        }
        catch (Exception ex) {
            UncaughtExceptionsModel.getInstance().addException(ex);
        }
    }

    public static Band createTable(int columns, int headerRows, int dataRows) {
        Band cell;
        int cellNumber;
        Band row;
        int r;
        Band table = new Band();
        table.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, (Object)"table");
        table.getStyle().setStyleProperty(BandStyleKeys.TABLE_LAYOUT, (Object)TableLayout.fixed);
        if (headerRows > 0) {
            Band tableHeader = new Band();
            tableHeader.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, (Object)"table-header");
            for (r = 0; r < headerRows; ++r) {
                row = new Band();
                row.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, (Object)"table-row");
                row.setName("r-" + r);
                for (cellNumber = 0; cellNumber < columns; ++cellNumber) {
                    cell = InsertTableAction.createCell(1, 1);
                    row.addElement((Element)cell);
                }
                tableHeader.addElement((Element)row);
            }
            table.addElement((Element)tableHeader);
        }
        Band tableBody = new Band();
        tableBody.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, (Object)"table-body");
        for (r = 0; r < dataRows; ++r) {
            row = new Band();
            row.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, (Object)"table-row");
            row.setName("r-" + (r + headerRows));
            for (cellNumber = 0; cellNumber < columns; ++cellNumber) {
                cell = InsertTableAction.createCell(1, 1);
                row.addElement((Element)cell);
            }
            tableBody.addElement((Element)row);
        }
        table.addElement((Element)tableBody);
        return table;
    }

    public static Band createCell(int rowSpan, int colSpan) {
        Band tableCell = new Band();
        tableCell.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, (Object)"table-cell");
        tableCell.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)Float.valueOf(150.0f));
        tableCell.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)Float.valueOf(200.0f));
        tableCell.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/table", "rowspan", (Object)rowSpan);
        tableCell.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/table", "colspan", (Object)colSpan);
        return tableCell;
    }

    private class FocusUpdateHandler
    extends FocusTracker {
        private FocusUpdateHandler() {
        }

        protected void focusChanged(Component c) {
            InsertTableAction.this.updateSelection();
        }
    }
}

