/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.crosstab.CreateCrosstabDialog;
import org.pentaho.reporting.designer.core.editor.crosstab.CrosstabEditSupport;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupDataBody;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.SubGroupBody;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.filter.types.CrosstabElementType;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public final class InsertCrosstabGroupAction
extends AbstractElementSelectionAction
implements SettingsListener {
    private static final long serialVersionUID = 6766753579037904765L;

    public InsertCrosstabGroupAction() {
        this.putValue("Name", ActionMessages.getString("InsertCrosstabGroupAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("InsertCrosstabGroupAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("InsertCrosstabGroupAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("InsertCrosstabGroupAction.Accelerator"));
        this.putValue("SmallIcon", IconLoader.getInstance().getGenericSquare());
        this.setVisible(WorkspaceSettings.getInstance().isVisible((MetaData)CrosstabElementType.INSTANCE.getMetaData()));
        WorkspaceSettings.getInstance().addSettingsListener(this);
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        try {
            ReportDesignerContext context;
            Component parent;
            Window window;
            AbstractReportDefinition report;
            Object selectedElement = report = activeContext.getReportDefinition();
            if (this.getSelectionModel().getSelectionCount() > 0) {
                selectedElement = this.getSelectionModel().getSelectedElement(0);
            }
            CreateCrosstabDialog dialog = (window = LibSwingUtil.getWindowAncestor((Component)(parent = (context = this.getReportDesignerContext()).getView().getParent()))) instanceof JDialog ? new CreateCrosstabDialog((JDialog)window) : (window instanceof JFrame ? new CreateCrosstabDialog((JFrame)window) : new CreateCrosstabDialog());
            if (selectedElement != report && !(selectedElement instanceof RelationalGroup)) {
                return;
            }
            CrosstabGroup newGroup = dialog.createCrosstab(context, null);
            if (newGroup == null) {
                return;
            }
            if (selectedElement == report) {
                Group rootGroup = report.getRootGroup();
                report.setRootGroup((Group)newGroup);
                activeContext.getUndo().addChange(ActionMessages.getString("InsertCrosstabGroupAction.UndoName", new Object[0]), new CrosstabEditSupport.EditGroupOnReportUndoEntry(rootGroup, (Group)newGroup));
                return;
            }
            RelationalGroup selectedGroup = (RelationalGroup)selectedElement;
            GroupBody bodyElement = selectedGroup.getBody();
            if (bodyElement instanceof SubGroupBody) {
                SubGroupBody subGroupBodyReportElement = (SubGroupBody)bodyElement;
                Group oldBodyContent = subGroupBodyReportElement.getGroup();
                subGroupBodyReportElement.setGroup((Group)newGroup);
                activeContext.getUndo().addChange(ActionMessages.getString("InsertGroupAction.UndoName", new Object[0]), new CrosstabEditSupport.EditGroupOnGroupUndoEntry(selectedGroup.getObjectID(), oldBodyContent, (Group)newGroup));
            } else if (bodyElement instanceof GroupDataBody) {
                GroupDataBody oldBody = CrosstabEditSupport.installCrosstabIntoLastGroup(selectedGroup, newGroup);
                this.getActiveContext().getUndo().addChange(ActionMessages.getString("InsertGroupAction.UndoName", new Object[0]), new InsertGroupOnDetailsUndoEntry(selectedGroup.getObjectID(), newGroup, oldBody));
            }
        }
        catch (Exception ex) {
            UncaughtExceptionsModel.getInstance().addException(ex);
        }
    }

    @Override
    protected void updateSelection() {
        if (!this.isVisible()) {
            this.setEnabled(false);
            return;
        }
        DocumentContextSelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel == null) {
            this.setEnabled(false);
            return;
        }
        if (selectionModel.getSelectionCount() == 0) {
            this.setEnabled(true);
            return;
        }
        if (!this.isSingleElementSelection()) {
            this.setEnabled(false);
            return;
        }
        AbstractReportDefinition report = this.getActiveContext().getReportDefinition();
        Object selectedElement = selectionModel.getSelectedElement(0);
        if (selectedElement == report || selectedElement instanceof RelationalGroup) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    @Override
    public void settingsChanged() {
        this.setVisible(WorkspaceSettings.getInstance().isVisible((MetaData)CrosstabElementType.INSTANCE.getMetaData()));
    }

    private static class InsertGroupOnDetailsUndoEntry
    implements UndoEntry {
        private InstanceID target;
        private CrosstabGroup newGroup;
        private GroupDataBody oldBody;

        public InsertGroupOnDetailsUndoEntry(InstanceID target, CrosstabGroup newGroup, GroupDataBody oldBody) {
            this.target = target;
            this.newGroup = newGroup;
            this.oldBody = (GroupDataBody)oldBody.derive();
        }

        @Override
        public void undo(ReportDocumentContext renderContext) {
            RelationalGroup selectedGroup = (RelationalGroup)ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
            selectedGroup.setBody((GroupBody)this.oldBody.derive());
        }

        @Override
        public void redo(ReportDocumentContext renderContext) {
            RelationalGroup selectedGroup = (RelationalGroup)ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
            CrosstabEditSupport.installCrosstabIntoLastGroup(selectedGroup, this.newGroup);
        }

        @Override
        public UndoEntry merge(UndoEntry newEntry) {
            return null;
        }
    }
}

