/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.groups.EditGroupDetailsDialog;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.undo.EditGroupUndoEntry;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public final class EditGroupAction
extends AbstractElementSelectionAction {
    public EditGroupAction() {
        this.putValue("Name", ActionMessages.getString("EditGroupAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("EditGroupAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("EditGroupAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("EditGroupAction.Accelerator"));
        this.putValue("SmallIcon", IconLoader.getInstance().getGroupIcon());
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentContextSelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel == null) {
            return;
        }
        if (selectionModel.getSelectionCount() != 1) {
            return;
        }
        Object selectedElement = selectionModel.getSelectedElement(0);
        if (!(selectedElement instanceof RelationalGroup)) {
            this.setEnabled(false);
            return;
        }
        EditGroupUndoEntry groupUndoEntry = EditGroupAction.performEditGroup(this.getReportDesignerContext(), selectedElement, false);
        if (groupUndoEntry != null) {
            ReportDocumentContext activeContext = this.getActiveContext();
            groupUndoEntry.redo(activeContext);
        }
    }

    public static EditGroupUndoEntry performEditGroup(ReportDesignerContext context, Object selectedElement, boolean addGroup) {
        Component parent = context.getView().getParent();
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        EditGroupDetailsDialog dialog = window instanceof JDialog ? new EditGroupDetailsDialog((JDialog)window) : (window instanceof JFrame ? new EditGroupDetailsDialog((JFrame)window) : new EditGroupDetailsDialog());
        RelationalGroup group = (RelationalGroup)selectedElement;
        return dialog.editGroup(group, context.getActiveContext(), addGroup);
    }

    @Override
    protected void updateSelection() {
        if (!this.isSingleElementSelection()) {
            this.setEnabled(false);
            return;
        }
        Object selectedElement = this.getSelectionModel().getSelectedElement(0);
        if (!(selectedElement instanceof RelationalGroup)) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

