/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.ReportDesignerDesignTimeContext;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.DataSourceEditUndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.designtime.DataFactoryChange;
import org.pentaho.reporting.engine.classic.core.designtime.DataFactoryChangeRecorder;
import org.pentaho.reporting.engine.classic.core.designtime.DataSourcePlugin;
import org.pentaho.reporting.engine.classic.core.designtime.DefaultDataFactoryChangeRecorder;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;

public class EditDataSourceAction
extends AbstractElementSelectionAction {
    public EditDataSourceAction() {
        this.putValue("Name", ActionMessages.getString("EditDataSourceAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("EditDataSourceAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("EditDataSourceAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("EditDataSourceAction.Accelerator"));
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    protected void updateSelection() {
        DocumentContextSelectionModel selectionModel1 = this.getSelectionModel();
        if (selectionModel1 == null) {
            this.setEnabled(false);
            return;
        }
        List<DataFactory> selectedObjects = selectionModel1.getSelectedElementsOfType(DataFactory.class);
        for (DataFactory dataFactory : selectedObjects) {
            DataFactoryMetaData metadata = dataFactory.getMetaData();
            if (!metadata.isEditable()) continue;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        List<DataFactory> selectedElements = this.getSelectionModel().getSelectedElementsOfType(DataFactory.class);
        Iterator<DataFactory> iterator = selectedElements.iterator();
        if (iterator.hasNext()) {
            DataFactory dataFactory = iterator.next();
            try {
                this.performEdit(dataFactory);
            }
            catch (ReportDataFactoryException e1) {
                UncaughtExceptionsModel.getInstance().addException(e1);
            }
            return;
        }
    }

    protected void performEdit(DataFactory dataFactory) throws ReportDataFactoryException {
        DataFactoryMetaData metadata = dataFactory.getMetaData();
        if (!metadata.isEditable()) {
            return;
        }
        DataSourcePlugin dataSourcePlugin = metadata.createEditor();
        DataFactory storedFactory = dataFactory.derive();
        if (!dataSourcePlugin.canHandle(dataFactory)) {
            return;
        }
        DefaultDataFactoryChangeRecorder recorder = new DefaultDataFactoryChangeRecorder();
        DataFactory editedDataFactory = dataSourcePlugin.performEdit((DesignTimeContext)new ReportDesignerDesignTimeContext(this.getReportDesignerContext()), dataFactory, null, (DataFactoryChangeRecorder)recorder);
        if (editedDataFactory == null) {
            return;
        }
        ReportDocumentContext activeContext = this.getActiveContext();
        AbstractReportDefinition report = activeContext.getReportDefinition();
        CompoundDataFactory collection = (CompoundDataFactory)report.getDataFactory();
        int j = collection.indexOfByReference(dataFactory);
        if (j == -1) {
            throw new IllegalStateException("Edited data-source does not exist in the report anymore.");
        }
        DefaultDataFactoryChangeRecorder.applyChanges((CompoundDataFactory)collection, (DataFactoryChange[])recorder.getChanges());
        DataFactory editedClone = editedDataFactory.derive();
        collection.set(j, editedDataFactory);
        activeContext.getUndo().addChange(ActionMessages.getString("EditDataSourceAction.UndoName", new Object[0]), new DataSourceEditUndoEntry(j, storedFactory, editedClone));
        report.notifyNodeChildRemoved((Object)dataFactory);
        report.notifyNodeChildAdded((Object)editedDataFactory);
    }
}

