/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.ReportDesignerDocumentContext;
import org.pentaho.reporting.designer.core.ReportDesignerView;
import org.pentaho.reporting.designer.core.auth.GlobalAuthenticationStore;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.settings.RecentFilesModel;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;

public abstract class AbstractReportDesignerContext
implements ReportDesignerContext {
    private PropertyChangeSupport propertyChangeSupport;
    private String statusText;
    private ReportDesignerDocumentContext activeContext;
    private ArrayList<ReportDesignerDocumentContext> contexts;
    private RecentFilesModel recentFilesModel;
    private boolean selectionWaiting;
    private GlobalAuthenticationStore authenticationStore;
    private int page;
    private int pageTotal;
    private ReportDesignerView view;

    public AbstractReportDesignerContext(ReportDesignerView view) {
        if (view == null) {
            throw new NullPointerException();
        }
        this.view = view;
        this.recentFilesModel = new RecentFilesModel();
        this.contexts = new ArrayList();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.authenticationStore = new GlobalAuthenticationStore();
    }

    @Override
    public RecentFilesModel getRecentFilesModel() {
        return this.recentFilesModel;
    }

    @Override
    public int addMasterReport(MasterReport masterReportElement) {
        this.setSelectionWaiting(false);
        masterReportElement.setDataFactory((DataFactory)CompoundDataFactory.normalize((DataFactory)masterReportElement.getDataFactory()));
        ReportRenderContext context = new ReportRenderContext(masterReportElement, (AbstractReportDefinition)masterReportElement, null, this.getGlobalAuthenticationStore());
        this.contexts.add(context);
        context.resetChangeTracker();
        masterReportElement.addReportModelListener((ReportModelListener)new SubReportsRemovealHandler(this));
        int index = this.contexts.size() - 1;
        this.propertyChangeSupport.fireIndexedPropertyChange("reportRenderContext", index, null, context);
        return index;
    }

    @Override
    public int addSubReport(ReportDocumentContext parentReportContext, SubReport subReportElement) {
        this.setSelectionWaiting(false);
        subReportElement.setDataFactory((DataFactory)CompoundDataFactory.normalize((DataFactory)subReportElement.getDataFactory()));
        ReportRenderContext context = new ReportRenderContext((MasterReport)parentReportContext.getContextRoot(), (AbstractReportDefinition)subReportElement, parentReportContext, this.getGlobalAuthenticationStore());
        this.contexts.add(context);
        subReportElement.addReportModelListener((ReportModelListener)new SubReportsRemovealHandler(this));
        int index = this.contexts.size() - 1;
        this.propertyChangeSupport.fireIndexedPropertyChange("reportRenderContext", index, null, context);
        return index;
    }

    @Override
    public void removeReportRenderContext(int index) {
        this.setSelectionWaiting(false);
        ReportDesignerDocumentContext context = this.contexts.get(index);
        try {
            this.contexts.remove(index);
            if (context != this.activeContext) {
                this.propertyChangeSupport.fireIndexedPropertyChange("reportRenderContext", index, context, null);
                return;
            }
            if (index == 0) {
                if (!this.contexts.isEmpty()) {
                    this.setActiveDocument(this.contexts.get(0));
                } else {
                    this.setActiveDocument((ReportDesignerDocumentContext)null);
                }
            } else {
                this.setActiveDocument(this.contexts.get(index - 1));
            }
            this.propertyChangeSupport.fireIndexedPropertyChange("reportRenderContext", index, context, null);
        }
        finally {
            context.dispose();
        }
    }

    @Override
    public int getReportRenderContextCount() {
        return this.contexts.size();
    }

    @Override
    public ReportDesignerDocumentContext getDocumentContext(int index) {
        return this.contexts.get(index);
    }

    @Override
    public ReportRenderContext getReportRenderContext(int index) {
        ReportDesignerDocumentContext documentContext = this.getDocumentContext(index);
        if (documentContext instanceof ReportRenderContext) {
            return (ReportRenderContext)documentContext;
        }
        return null;
    }

    @Override
    public ReportDocumentContext getActiveContext() {
        if (this.activeContext instanceof ReportDocumentContext) {
            return (ReportDocumentContext)this.activeContext;
        }
        return null;
    }

    public ReportDesignerDocumentContext getActiveDocument() {
        return this.activeContext;
    }

    public void setActiveDocument(ReportDesignerDocumentContext activeContext) {
        if (activeContext != null && !this.contexts.contains(activeContext)) {
            throw new IllegalArgumentException("None of my contexts");
        }
        this.setSelectionWaiting(false);
        ReportDesignerDocumentContext context = this.activeContext;
        this.activeContext = activeContext;
        this.propertyChangeSupport.firePropertyChange("activeContext", context, activeContext);
    }

    public String getStatusText() {
        return this.statusText;
    }

    @Override
    public void setStatusText(String statusText) {
        String oldText = this.statusText;
        this.statusText = statusText;
        this.propertyChangeSupport.firePropertyChange("statusText", oldText, statusText);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public ReportDesignerView getView() {
        return this.view;
    }

    @Override
    public int findActiveContextIndex() {
        for (int i = 0; i < this.contexts.size(); ++i) {
            ReportDesignerDocumentContext context = this.contexts.get(i);
            if (context != this.activeContext) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isSelectionWaiting() {
        return this.selectionWaiting;
    }

    @Override
    public void setSelectionWaiting(boolean selectionWaiting) {
        boolean oldSelectionWaiting = this.selectionWaiting;
        this.selectionWaiting = selectionWaiting;
        this.propertyChangeSupport.firePropertyChange("selectionWaiting", oldSelectionWaiting, selectionWaiting);
    }

    @Override
    public GlobalAuthenticationStore getGlobalAuthenticationStore() {
        return this.authenticationStore;
    }

    @Override
    public void setPageNumbers(int page, int pageTotal) {
        int oldPage = this.page;
        int oldPageTotal = this.pageTotal;
        this.page = page;
        this.pageTotal = pageTotal;
        this.propertyChangeSupport.firePropertyChange("pageTotal", oldPageTotal, pageTotal);
        this.propertyChangeSupport.firePropertyChange("page", oldPage, page);
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public int getPageTotal() {
        return this.pageTotal;
    }

    @Override
    public Component getParent() {
        return this.getView().getParent();
    }

    @Override
    public JPopupMenu getPopupMenu(String id) {
        return this.getView().getPopupMenu(id);
    }

    @Override
    public JComponent getToolBar(String id) {
        return this.getView().getToolBar(id);
    }

    private static class SubReportsRemovealHandler
    implements ReportModelListener {
        private AbstractReportDesignerContext designerContext;

        private SubReportsRemovealHandler(AbstractReportDesignerContext designerContext) {
            this.designerContext = designerContext;
        }

        public void nodeChanged(ReportModelEvent event) {
            this.designerContext.setSelectionWaiting(false);
            if (!event.isNodeDeleteEvent()) {
                return;
            }
            Object o = event.getParameter();
            if (!(o instanceof Section)) {
                return;
            }
            SubReport[] subReports = ModelUtility.findSubReports((Section)o);
            block0: for (int i = 0; i < subReports.length; ++i) {
                SubReport report = subReports[i];
                int count = this.designerContext.getReportRenderContextCount();
                for (int x = 0; x < count; ++x) {
                    ReportRenderContext context = this.designerContext.getReportRenderContext(x);
                    if (context.getReportDefinition() != report) continue;
                    this.designerContext.removeReportRenderContext(x);
                    continue block0;
                }
            }
        }
    }
}

