/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ServletToBeanProxy
implements Servlet {
    private static final long serialVersionUID = 2934977002901688130L;
    private static final Log logger = LogFactory.getLog(ServletToBeanProxy.class);
    protected Servlet delegate;
    private ServletConfig servletConfig;
    private boolean initialized = false;
    private boolean servletContainerManaged = false;

    public void destroy() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[destroy]");
        }
        if (this.delegate != null && this.servletContainerManaged) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"servletContainerManaged=true so calling destroy");
            }
            this.delegate.destroy();
        }
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (!this.initialized) {
            this.doInit();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[service]");
        }
        this.delegate.service(req, res);
    }

    private synchronized void doInit() throws ServletException {
        if (this.initialized) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[doInit]");
        }
        String targetBean = this.servletConfig.getInitParameter("targetBean");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("targetBean=" + targetBean));
        }
        if ("".equals(targetBean)) {
            targetBean = null;
        }
        String lifecycle = this.servletConfig.getInitParameter("lifecycle");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("lifecycle=" + lifecycle));
        }
        if ("servlet-container-managed".equals(lifecycle)) {
            this.servletContainerManaged = true;
        }
        ApplicationContext ctx = this.getContext(this.servletConfig);
        String beanName = null;
        if (targetBean != null && ctx.containsBean(targetBean)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"using targetBean");
            }
            beanName = targetBean;
        } else {
            Class<?> targetClass;
            String targetClassString;
            if (targetBean != null) {
                throw new ServletException("targetBean '" + targetBean + "' not found in context");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"using targetClass");
            }
            if ((targetClassString = this.servletConfig.getInitParameter("targetClass")) == null || "".equals(targetClassString)) {
                throw new ServletException("targetClass or targetBean must be specified");
            }
            try {
                targetClass = Thread.currentThread().getContextClassLoader().loadClass(targetClassString);
            }
            catch (ClassNotFoundException ex) {
                throw new ServletException("Class of type " + targetClassString + " not found in classloader");
            }
            Map beans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)ctx, targetClass, (boolean)true, (boolean)true);
            if (beans.size() == 0) {
                throw new ServletException("Bean context must contain at least one bean of type " + targetClassString);
            }
            beanName = (String)beans.keySet().iterator().next();
        }
        Object object = ctx.getBean(beanName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("got bean=" + object));
        }
        if (!(object instanceof Servlet)) {
            throw new ServletException("Bean '" + beanName + "' does not implement javax.servlet.Servlet");
        }
        this.delegate = (Servlet)object;
        if (this.servletContainerManaged) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"servletContainerManaged=true so calling init");
            }
            this.delegate.init(this.servletConfig);
        }
        this.initialized = true;
    }

    public ServletConfig getServletConfig() {
        return this.delegate.getServletConfig();
    }

    public String getServletInfo() {
        return this.delegate.getServletInfo();
    }

    protected ApplicationContext getContext(ServletConfig config) {
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)config.getServletContext());
    }

    public void init(ServletConfig config) throws ServletException {
        this.servletConfig = config;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[init]");
        }
        String strategy = this.servletConfig.getInitParameter("init");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("init (strategy)=" + strategy));
        }
        if (strategy != null && strategy.toLowerCase().equals("lazy")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"strategy=lazy so deferring init");
            }
            return;
        }
        this.doInit();
    }
}

