/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.settings;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.pentaho.platform.settings.ServerPort;
import org.pentaho.platform.settings.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerPortRegistry {
    static ServerPortRegistry instance = new ServerPortRegistry();
    private static ConcurrentHashMap<String, ServerPort> serverPorts;
    private static ConcurrentHashMap<String, Service> services;
    private static Logger logger;

    private ServerPortRegistry() {
        ServerPortRegistry.clear();
    }

    public static void addPort(ServerPort serverPort) {
        if (serverPorts.get(serverPort.getId()) != null && serverPorts.get(serverPort.getId()).getAssignedPort() != null) {
            throw new IllegalStateException("Another port has already been assigned with this ID.");
        }
        serverPorts.put(serverPort.getId(), serverPort);
        String serviceName = serverPort.getServiceName();
        Service service = services.get(serviceName);
        if (service == null) {
            logger.warn("Server Port added with no service.  Adding service without description");
            service = new Service(serverPort.getServiceName(), "Unknown Description");
            services.put(serviceName, service);
        }
        Set<ServerPort> servicePorts = service.getServerPorts();
        servicePorts.add(serverPort);
    }

    public static void addService(Service service) {
        if (!services.contains(service.getServiceName())) {
            services.put(service.getServiceName(), service);
        }
    }

    public static void removePort(ServerPort serverPort) {
        Service service = services.get(serverPort.getServiceName());
        service.getServerPorts().remove(serverPort);
        serverPorts.remove(serverPort.getId());
    }

    public static void clear() {
        serverPorts = new ConcurrentHashMap();
        services = new ConcurrentHashMap();
    }

    public static Service getService(String serviceName) {
        return services.get(serviceName);
    }

    public static ServerPort getPort(String portId) {
        return serverPorts.get(portId);
    }

    public static Set<Service> getServices() {
        return new HashSet<Service>(services.values());
    }

    public static Set<ServerPort> getPorts() {
        return new HashSet<ServerPort>(serverPorts.values());
    }

    static {
        logger = LoggerFactory.getLogger(ServerPortRegistry.class);
    }
}

