/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.ldap.search;

import javax.naming.directory.SearchControls;
import org.pentaho.platform.plugin.services.security.userrole.ldap.search.LdapSearchParams;
import org.pentaho.platform.plugin.services.security.userrole.ldap.search.LdapSearchParamsFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class LdapSearchParamsFactoryImpl
implements LdapSearchParamsFactory,
InitializingBean {
    private String base;
    private String filter;
    private SearchControls searchControls;

    public LdapSearchParamsFactoryImpl() {
    }

    public LdapSearchParamsFactoryImpl(String base, String filter) {
        this(base, filter, new SearchControls());
    }

    public LdapSearchParamsFactoryImpl(String base, String filter, SearchControls searchControls) {
        this.base = base;
        this.filter = filter;
        this.searchControls = searchControls;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.base);
        Assert.hasLength((String)this.filter);
    }

    @Override
    public LdapSearchParams createParams(Object[] filterArgs) {
        return new LdapSearchParamsImpl(this.base, this.filter, filterArgs, this.searchControls);
    }

    private class LdapSearchParamsImpl
    implements LdapSearchParams {
        private String implBase;
        private String implFilter;
        private Object[] filterArgs;
        private SearchControls implSearchControls;

        private LdapSearchParamsImpl(String base, String filter, Object[] filterArgs, SearchControls searchControls) {
            this.implBase = base;
            this.implFilter = filter;
            this.filterArgs = filterArgs;
            this.implSearchControls = searchControls;
        }

        @Override
        public String getBase() {
            return this.implBase;
        }

        @Override
        public String getFilter() {
            return this.implFilter;
        }

        @Override
        public Object[] getFilterArgs() {
            return this.filterArgs;
        }

        @Override
        public SearchControls getSearchControls() {
            return this.implSearchControls;
        }
    }
}

