/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importexport.legacy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.plugin.services.importexport.ImportSource;
import org.pentaho.platform.plugin.services.importexport.InitializationException;
import org.pentaho.platform.plugin.services.importexport.RepositoryFileBundle;
import org.pentaho.platform.plugin.services.importexport.legacy.AbstractImportSource;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.repository.messages.Messages;
import org.springframework.util.Assert;

public class ZipSolutionRepositoryImportSource
extends AbstractImportSource {
    private String charSet;
    private ZipInputStream zipInputStream;
    private List<ImportSource.IRepositoryFileBundle> files;

    public ZipSolutionRepositoryImportSource(ZipInputStream zipInputStream, String charSet) throws InitializationException {
        Assert.notNull((Object)zipInputStream);
        Assert.hasText((String)charSet);
        this.zipInputStream = zipInputStream;
        this.charSet = charSet;
        this.files = new ArrayList<ImportSource.IRepositoryFileBundle>();
        this.initialize();
    }

    protected void initialize() throws InitializationException {
        try {
            ZipEntry entry = this.zipInputStream.getNextEntry();
            while (entry != null) {
                boolean isDir;
                String entryName = RepositoryFilenameUtils.separatorsToRepository((String)entry.getName());
                String extension = RepositoryFilenameUtils.getExtension((String)entryName);
                File tempFile = null;
                boolean bl = isDir = entry.getSize() == 0L;
                if (!isDir) {
                    tempFile = File.createTempFile("zip", null);
                    tempFile.deleteOnExit();
                    FileOutputStream fos = new FileOutputStream(tempFile);
                    IOUtils.copy((InputStream)this.zipInputStream, (OutputStream)fos);
                    fos.close();
                }
                File file = new File(entryName);
                RepositoryFile repoFile = new RepositoryFile.Builder(file.getName()).folder(isDir).hidden(false).build();
                String parentDir = new File(entryName).getParent() == null ? "/" : new File(entryName).getParent() + "/";
                RepositoryFileBundle repoFileBundle = new RepositoryFileBundle(repoFile, null, parentDir, tempFile, this.charSet, this.getMimeType(extension.toLowerCase()));
                this.files.add(repoFileBundle);
                this.zipInputStream.closeEntry();
                entry = this.zipInputStream.getNextEntry();
            }
            this.zipInputStream.close();
        }
        catch (IOException exception) {
            String errorMessage = Messages.getInstance().getErrorString("", new Object[]{exception.getLocalizedMessage()});
            throw new InitializationException(errorMessage, exception);
        }
    }

    @Override
    public Iterable<ImportSource.IRepositoryFileBundle> getFiles() throws IOException {
        return this.files;
    }

    @Override
    public int getCount() {
        return this.files.size();
    }
}

