/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.cache;

import java.util.Date;
import java.util.Map;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.pentaho.platform.api.cache.ILastModifiedCacheItem;

public class LastModifiedCache
implements ILastModifiedCacheItem,
Cache {
    private Cache cache;
    private long lastModified;

    public LastModifiedCache(Cache cache) {
        this.cache = cache;
        this.setLastModified();
    }

    public LastModifiedCache(Cache cache, long lastModified) {
        this.cache = cache;
        this.lastModified = lastModified;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    protected void setLastModified() {
        this.lastModified = new Date().getTime();
    }

    public String getCacheKey() {
        return this.cache.getRegionName();
    }

    public Object read(Object o) throws CacheException {
        return this.cache.read(o);
    }

    public Object get(Object o) throws CacheException {
        return this.cache.get(o);
    }

    public void put(Object o, Object o1) throws CacheException {
        this.cache.put(o, o1);
        this.setLastModified();
    }

    public void update(Object o, Object o1) throws CacheException {
        this.cache.update(o, o1);
        this.setLastModified();
    }

    public void remove(Object o) throws CacheException {
        this.cache.remove(o);
        this.setLastModified();
    }

    public void clear() throws CacheException {
        this.cache.clear();
        this.setLastModified();
    }

    public void destroy() throws CacheException {
        this.cache.destroy();
        this.setLastModified();
    }

    public void lock(Object o) throws CacheException {
        this.cache.lock(o);
    }

    public void unlock(Object o) throws CacheException {
        this.cache.unlock(o);
    }

    public long nextTimestamp() {
        return this.cache.nextTimestamp();
    }

    public int getTimeout() {
        return this.cache.getTimeout();
    }

    public String getRegionName() {
        return this.cache.getRegionName();
    }

    public long getSizeInMemory() {
        return this.cache.getSizeInMemory();
    }

    public long getElementCountInMemory() {
        return this.cache.getElementCountInMemory();
    }

    public long getElementCountOnDisk() {
        return this.cache.getElementCountOnDisk();
    }

    public Map toMap() {
        try {
            return this.cache.toMap();
        }
        catch (Exception e) {
            return null;
        }
    }
}

