/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.openflashchart.factory;

import java.util.ArrayList;
import java.util.Properties;
import ofc4j.model.Chart;
import ofc4j.model.Text;
import ofc4j.model.axis.Axis;
import ofc4j.model.axis.Label;
import ofc4j.model.axis.XAxis;
import ofc4j.model.axis.YAxis;
import ofc4j.model.elements.Element;
import org.apache.commons.logging.Log;
import org.dom4j.Node;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.PentahoDataTransmuter;
import org.pentaho.platform.engine.services.runtime.TemplateUtil;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.action.openflashchart.factory.IChartFactory;

public abstract class AbstractChartFactory
implements IChartFactory {
    protected static final String COLOR_NODE_LOC = "color";
    private static final String TITLE_NODE_LOC = "title";
    private static final String TITLE_FONT_NODE_LOC = "title-font";
    private static final String DATASET_TYPE_NODE_LOC = "dataset-type";
    private static final String COLOR_PALETTE_NODE_LOC = "color-palette";
    private static final String PLOT_BACKGROUND_NODE_LOC = "plot-background";
    private static final String PLOT_BACKGROUND_COLOR_XPATH = "@type";
    private static final String CHART_BACKGROUND_NODE_LOC = "chart-background";
    private static final String CHART_BACKGROUND_COLOR_XPATH = "@type";
    private static final String URL_TEMPLATE_NODE_LOC = "url-template";
    private static final String TOOLTIP_NODE_LOC = "tooltip";
    private static final String ORIENTATION_NODE_LOC = "orientation";
    private static final String ALPHA_NODE_LOC = "alpha";
    private static final String FONT_FAMILY_NODE_LOC = "font-family";
    private static final String FONT_SIZE_NODE_LOC = "size";
    private static final String FONT_BOLD_NODE_LOC = "is-bold";
    private static final String FONT_ITALIC_NODE_LOC = "is-italic";
    private static final String DOMAIN_STROKE_NODE_LOC = "domain-stroke";
    private static final String DOMAIN_GRID_COLOR_NODE_LOC = "domain-grid-color";
    private static final String DOMAIN_COLOR_NODE_LOC = "domain-color";
    private static final String DOMAIN_STEPS_NODE_LOC = "domain-steps";
    private static final String DOMAIN_TITLE_NODE_LOC = "domain-title";
    private static final String DOMAIN_TITLE_FONT_NODE_LOC = "domain-title-font";
    private static final String DOMAIN_MAXIMUM_NODE_LOC = "domain-maximum";
    private static final String DOMAIN_MINIMUM_NODE_LOC = "domain-minimum";
    private static final String DOMAIN_ROTATION_NODE_LOC = "domain-label-rotation";
    private static final String DOMAIN_ROTATION_DIR_NODE_LOC = "domain-label-rotation-dir";
    private static final String RANGE_STROKE_NODE_LOC = "range-stroke";
    private static final String RANGE_GRID_COLOR_NODE_LOC = "range-grid-color";
    private static final String RANGE_COLOR_NODE_LOC = "range-color";
    protected static final String RANGE_STEPS_NODE_LOC = "range-steps";
    private static final String RANGE_TITLE_NODE_LOC = "range-title";
    private static final String RANGE_TITLE_FONT_NODE_LOC = "range-title-font";
    private static final String RANGE_MAXIMUM_NODE_LOC = "range-maximum";
    private static final String RANGE_MINIMUM_NODE_LOC = "range-minimum";
    private static final String COLOR_TYPE = "color";
    private static final String CSS_FONT_STYLES = "font-family: {fontfamily}; font-size: {fontsize}px; font-weight: {fontweight}; font-style: {fontstyle};";
    protected static final String HORIZONTAL_ORIENTATION = "horizontal";
    protected static final String VERTICAL_ORIENTATION = "vertical";
    protected static final String CATEGORY_TYPE = "CategoryDataset";
    protected static final String XY_TYPE = "XYSeriesCollection";
    protected static final String XYZ_TYPE = "XYZSeriesCollection";
    private static final String DATASET_TYPE_DEFAULT = "CategoryDataset";
    private static final String CSS_FONT_FAMILY_DEFAULT = "Arial";
    private static final String CSS_FONT_SIZE_DEFAULT = "14";
    private static final String CSS_FONT_WEIGHT_DEFAULT = "normal";
    private static final String CSS_FONT_STYLE_DEFAULT = "normal";
    protected static final String AXIS_GRID_COLOR_DEFAULT = "#aaaaaa";
    protected static final String AXIS_COLOR_DEFAULT = "#000000";
    protected static final String ORIENTATION_DEFAULT = "vertical";
    protected static final String[] COLORS_DEFAULT = new String[]{"#006666", "#0066CC", "#009999", "#336699", "#339966", "#3399FF", "#663366", "#666666", "#666699", "#669999", "#6699CC", "#66CCCC", "#993300", "#999933", "#999966", "#999999", "#9999CC", "#9999FF", "#99CC33", "#99CCCC", "#99CCFF", "#CC6600", "#CC9933", "#CCCC33", "#CCCC66", "#CCCC99", "#CCCCCC", "#FF9900", "#FFCC00", "#FFCC66"};
    protected ArrayList<String> colors = new ArrayList();
    protected Chart chart = new Chart();
    protected ArrayList<Element> elements = new ArrayList();
    protected Node chartNode;
    private Log log;
    public String[] rowHeaders;
    public String[] columnHeaders;
    public IPentahoResultSet data;
    public boolean hasRowHeaders = false;
    public boolean hasColumnHeaders = false;
    protected String datasetType;
    protected String orientation;
    protected String baseURLTemplate;
    protected String tooltipText;
    protected Float alpha;

    protected abstract void createElements();

    protected void setupStyles() {
        Node temp = this.chartNode.selectSingleNode(TOOLTIP_NODE_LOC);
        if (AbstractChartFactory.getValue(temp) != null) {
            this.tooltipText = AbstractChartFactory.getValue(temp);
        }
        if (AbstractChartFactory.getValue(temp = this.chartNode.selectSingleNode(ALPHA_NODE_LOC)) != null) {
            this.alpha = Float.valueOf(Float.parseFloat(AbstractChartFactory.getValue(temp)));
        }
    }

    @Override
    public void setChartNode(Node chartNode) {
        this.chartNode = chartNode;
    }

    @Override
    public void setLog(Log log) {
        this.log = log;
    }

    public void validateData() {
        Object data;
        if (this.getRowCount() < 1) {
            throw new RuntimeException(Messages.getInstance().getErrorString("AbstractChartFactory.ERROR_0001_ROW_COUNT"));
        }
        if (this.getColumnCount() < 1) {
            throw new RuntimeException(Messages.getInstance().getErrorString("AbstractChartFactory.ERROR_0002_COLUMN_COUNT"));
        }
        for (int c = 0; c < this.getColumnCount(); ++c) {
            data = this.getValueAt(0, c);
            if (data instanceof Number) continue;
            throw new RuntimeException(Messages.getInstance().getErrorString("AbstractChartFactory.ERROR_0003_INVALID_TYPE"));
        }
        for (int r = 1; r < this.getRowCount(); ++r) {
            data = this.getValueAt(r, 0);
            if (data instanceof Number) continue;
            throw new RuntimeException(Messages.getInstance().getErrorString("AbstractChartFactory.ERROR_0003_INVALID_TYPE"));
        }
    }

    @Override
    public String convertToJson() {
        Node temp = this.chartNode.selectSingleNode(DATASET_TYPE_NODE_LOC);
        this.datasetType = AbstractChartFactory.getValue(temp) != null ? AbstractChartFactory.getValue(temp) : "CategoryDataset";
        this.validateData();
        this.setupColors();
        this.setupStyles();
        this.setupDomain();
        this.setupOnclick();
        this.createElements();
        this.setupTitles();
        this.setupRange();
        this.chart.addElements(this.elements);
        return this.chart.toString();
    }

    protected void setupTitles() {
        Node rangeTitle = this.chartNode.selectSingleNode(RANGE_TITLE_NODE_LOC);
        Node rangeTitleFont = this.chartNode.selectSingleNode(RANGE_TITLE_FONT_NODE_LOC);
        Node title = this.chartNode.selectSingleNode(TITLE_NODE_LOC);
        Node domainTitle = this.chartNode.selectSingleNode(DOMAIN_TITLE_NODE_LOC);
        Node domainTitleFont = this.chartNode.selectSingleNode(DOMAIN_TITLE_FONT_NODE_LOC);
        Node titleFont = this.chartNode.selectSingleNode(TITLE_FONT_NODE_LOC);
        if (AbstractChartFactory.getValue(title) != null) {
            Text titleText = new Text();
            titleText.setText(AbstractChartFactory.getValue(title));
            titleText.setStyle(this.buildCSSStringFromNode(titleFont));
            this.chart.setTitle(titleText);
        }
        Text domainText = new Text();
        if (AbstractChartFactory.getValue(domainTitle) != null) {
            domainText.setText(AbstractChartFactory.getValue(domainTitle));
        } else {
            domainText.setText(this.columnHeaders[0]);
        }
        domainText.setStyle(this.buildCSSStringFromNode(domainTitleFont));
        Text rangeText = new Text();
        if (AbstractChartFactory.getValue(rangeTitle) != null) {
            rangeText.setText(AbstractChartFactory.getValue(rangeTitle));
            rangeText.setStyle(this.buildCSSStringFromNode(rangeTitleFont));
            this.chart.setYLegend(rangeText);
        }
        this.chart.setXLegend(domainText);
    }

    protected void setupColors() {
        String type;
        Node temp = this.chartNode.selectSingleNode(COLOR_PALETTE_NODE_LOC);
        if (temp != null) {
            Object[] colorNodes = temp.selectNodes("color").toArray();
            for (int j = 0; j < colorNodes.length; ++j) {
                this.colors.add(AbstractChartFactory.getValue((Node)colorNodes[j]));
            }
        } else {
            for (int i = 0; i < COLORS_DEFAULT.length; ++i) {
                this.colors.add(COLORS_DEFAULT[i]);
            }
        }
        if (AbstractChartFactory.getValue(temp = this.chartNode.selectSingleNode(PLOT_BACKGROUND_NODE_LOC)) != null && (type = temp.valueOf("@type")) != null && "color".equals(type)) {
            this.chart.setBackgroundColour(AbstractChartFactory.getValue(temp));
            this.chart.setInnerBackgroundColour(AbstractChartFactory.getValue(temp));
        }
        if (AbstractChartFactory.getValue(temp = this.chartNode.selectSingleNode(CHART_BACKGROUND_NODE_LOC)) != null && (type = temp.valueOf("@type")) != null && "color".equals(type)) {
            this.chart.setBackgroundColour(AbstractChartFactory.getValue(temp));
        }
    }

    public Axis setupDomain() {
        String[] labels = null;
        Integer domainMin = null;
        Integer domainMax = null;
        Integer stepforchart = null;
        String domainRotation = null;
        if ("CategoryDataset".equals(this.datasetType)) {
            int rowCount = this.getRowCount();
            labels = new String[rowCount];
            for (int j = 0; j < rowCount; ++j) {
                labels[j] = this.getRowHeader(j);
            }
        } else if (XYZ_TYPE.equals(this.datasetType) || XY_TYPE.equals(this.datasetType)) {
            int chunksize;
            domainMax = domainMin = Integer.valueOf(((Number)this.getValueAt(0, 0)).intValue());
            for (int r = 1; r < this.getRowCount(); ++r) {
                if (domainMin > ((Number)this.getValueAt(r, 0)).intValue()) {
                    domainMin = ((Number)this.getValueAt(r, 0)).intValue();
                }
                if (domainMax >= ((Number)this.getValueAt(r, 0)).intValue()) continue;
                domainMax = ((Number)this.getValueAt(r, 0)).intValue();
            }
            if (((Object)domainMin).equals(domainMax)) {
                if (domainMin == 0) {
                    domainMax = new Integer(100);
                } else if (domainMin < 0) {
                    domainMax = new Integer(0);
                } else {
                    domainMin = new Integer(0);
                }
            }
            int steps = 9;
            int diff = domainMax - domainMin;
            Node temp = this.chartNode.selectSingleNode(DOMAIN_STEPS_NODE_LOC);
            if (AbstractChartFactory.getValue(temp) != null) {
                steps = new Integer(AbstractChartFactory.getValue(temp));
            }
            if ((chunksize = diff / steps) > 0) {
                stepforchart = new Integer(chunksize);
                domainMin = domainMin >= 0 && domainMin - chunksize < 0 ? Integer.valueOf(0) : Integer.valueOf(domainMin - chunksize);
                domainMax = domainMin + chunksize * (steps + 2);
            }
            if (AbstractChartFactory.getValue(temp = this.chartNode.selectSingleNode(DOMAIN_MINIMUM_NODE_LOC)) != null) {
                domainMin = (int)new Integer(AbstractChartFactory.getValue(temp));
            }
            if (AbstractChartFactory.getValue(temp = this.chartNode.selectSingleNode(DOMAIN_MAXIMUM_NODE_LOC)) != null) {
                domainMax = (int)new Integer(AbstractChartFactory.getValue(temp));
            }
        }
        String domainColor = AXIS_COLOR_DEFAULT;
        String domainGridColor = AXIS_GRID_COLOR_DEFAULT;
        int domainStroke = 1;
        Node temp = this.chartNode.selectSingleNode(DOMAIN_COLOR_NODE_LOC);
        if (AbstractChartFactory.getValue(temp) != null) {
            domainColor = AbstractChartFactory.getValue(temp);
        }
        if (AbstractChartFactory.getValue(temp = this.chartNode.selectSingleNode(DOMAIN_GRID_COLOR_NODE_LOC)) != null) {
            domainGridColor = AbstractChartFactory.getValue(temp);
        }
        if (AbstractChartFactory.getValue(temp = this.chartNode.selectSingleNode(DOMAIN_STROKE_NODE_LOC)) != null) {
            domainStroke = Integer.parseInt(AbstractChartFactory.getValue(temp));
        }
        if (AbstractChartFactory.getValue(temp = this.chartNode.selectSingleNode(DOMAIN_ROTATION_NODE_LOC)) != null) {
            domainRotation = AbstractChartFactory.getValue(temp);
        }
        this.orientation = AbstractChartFactory.getValue(temp = this.chartNode.selectSingleNode(ORIENTATION_NODE_LOC)) != null ? AbstractChartFactory.getValue(temp) : "vertical";
        if (HORIZONTAL_ORIENTATION.equals(this.orientation)) {
            YAxis yaxis = new YAxis();
            if (labels != null) {
                String[] reversedLabels = new String[labels.length];
                int reversedLabelCount = 0;
                for (int i = reversedLabels.length - 1; i >= 0; --i) {
                    reversedLabels[reversedLabelCount++] = labels[i];
                }
                yaxis.setLabels(reversedLabels);
            }
            yaxis.setStroke(Integer.valueOf(domainStroke));
            yaxis.setColour(domainColor);
            yaxis.setGridColour(domainGridColor);
            if (domainMin != null && domainMax != null) {
                yaxis.setRange(Integer.valueOf(domainMin), Integer.valueOf(domainMax), stepforchart);
            }
            this.chart.setYAxis(yaxis);
            return yaxis;
        }
        XAxis xaxis = new XAxis();
        if (labels != null) {
            xaxis.addLabels(labels);
        }
        xaxis.setStroke(Integer.valueOf(domainStroke));
        xaxis.setColour(domainColor);
        xaxis.setGridColour(domainGridColor);
        if (domainMin != null && domainMax != null) {
            xaxis.setRange(Integer.valueOf(domainMin), Integer.valueOf(domainMax), stepforchart);
        }
        if (domainRotation != null) {
            Label.Rotation rot = null;
            rot = domainRotation.equals("vertical") ? Label.Rotation.VERTICAL : (domainRotation.equals("diagonal") ? Label.Rotation.DIAGONAL : Label.Rotation.HORIZONTAL);
            xaxis.getLabels().setRotation(rot);
        }
        this.chart.setXAxis(xaxis);
        return xaxis;
    }

    public MinMax getRangeMinMax() {
        int rangeMin = 0;
        int rangeMax = 100;
        if (XYZ_TYPE.equals(this.datasetType) || XY_TYPE.equals(this.datasetType)) {
            rangeMax = rangeMin = ((Number)this.getValueAt(0, 1)).intValue();
            for (int r = 0; r < this.getRowCount(); ++r) {
                if (rangeMin > ((Number)this.getValueAt(r, 1)).intValue()) {
                    rangeMin = ((Number)this.getValueAt(r, 1)).intValue();
                }
                if (rangeMax >= ((Number)this.getValueAt(r, 1)).intValue()) continue;
                rangeMax = ((Number)this.getValueAt(r, 1)).intValue();
            }
        } else {
            rangeMax = rangeMin = ((Number)this.getValueAt(0, 0)).intValue();
            for (int c = 0; c < this.getColumnCount(); ++c) {
                for (int r = 0; r < this.getRowCount(); ++r) {
                    if (rangeMin > ((Number)this.getValueAt(r, c)).intValue()) {
                        rangeMin = ((Number)this.getValueAt(r, c)).intValue();
                    }
                    if (rangeMax >= ((Number)this.getValueAt(r, c)).intValue()) continue;
                    rangeMax = ((Number)this.getValueAt(r, c)).intValue();
                }
            }
        }
        MinMax minMax = null;
        minMax = rangeMin == rangeMax ? (rangeMin == 0 ? new MinMax(0, 100) : (rangeMin < 0 ? new MinMax(rangeMin, 0) : new MinMax(0, rangeMax))) : new MinMax(rangeMin, rangeMax);
        return minMax;
    }

    public Axis setupRange() {
        int rangeMin = 0;
        int rangeMax = 100;
        int steps = 9;
        String rangeColor = AXIS_COLOR_DEFAULT;
        String rangeGridColor = AXIS_GRID_COLOR_DEFAULT;
        int rangeStroke = 1;
        MinMax rangeMinMax = this.getRangeMinMax();
        rangeMin = rangeMinMax.min;
        rangeMax = rangeMinMax.max;
        boolean minDefined = false;
        boolean maxDefined = false;
        Node temp = this.chartNode.selectSingleNode(RANGE_MINIMUM_NODE_LOC);
        if (AbstractChartFactory.getValue(temp) != null) {
            rangeMin = new Integer(AbstractChartFactory.getValue(temp));
            minDefined = true;
        }
        if (AbstractChartFactory.getValue(temp = this.chartNode.selectSingleNode(RANGE_MAXIMUM_NODE_LOC)) != null) {
            rangeMax = new Integer(AbstractChartFactory.getValue(temp));
            maxDefined = true;
        }
        if (AbstractChartFactory.getValue(temp = this.chartNode.selectSingleNode(RANGE_STEPS_NODE_LOC)) != null) {
            steps = new Integer(AbstractChartFactory.getValue(temp));
        }
        if (AbstractChartFactory.getValue(temp = this.chartNode.selectSingleNode(RANGE_COLOR_NODE_LOC)) != null) {
            rangeColor = AbstractChartFactory.getValue(temp);
        }
        if (AbstractChartFactory.getValue(temp = this.chartNode.selectSingleNode(RANGE_GRID_COLOR_NODE_LOC)) != null) {
            rangeGridColor = AbstractChartFactory.getValue(temp);
        }
        if (AbstractChartFactory.getValue(temp = this.chartNode.selectSingleNode(RANGE_STROKE_NODE_LOC)) != null) {
            rangeStroke = Integer.parseInt(AbstractChartFactory.getValue(temp));
        }
        int diff = rangeMax - rangeMin;
        int chunksize = diff / steps;
        Integer stepforchart = null;
        if (chunksize > 0) {
            stepforchart = new Integer(chunksize);
            if (!minDefined) {
                rangeMin = rangeMin >= 0 && rangeMin - chunksize < 0 ? 0 : (rangeMin -= chunksize);
            }
            if (!maxDefined) {
                rangeMax = rangeMin + chunksize * (steps + 2);
            }
        }
        if (HORIZONTAL_ORIENTATION.equals(this.orientation)) {
            XAxis xaxis = new XAxis();
            xaxis.setRange(Integer.valueOf(rangeMin), Integer.valueOf(rangeMax), stepforchart);
            xaxis.setStroke(Integer.valueOf(rangeStroke));
            xaxis.setColour(rangeColor);
            xaxis.setGridColour(rangeGridColor);
            this.chart.setXAxis(xaxis);
            return xaxis;
        }
        YAxis yaxis = new YAxis();
        yaxis.setRange(Integer.valueOf(rangeMin), Integer.valueOf(rangeMax), stepforchart);
        yaxis.setStroke(Integer.valueOf(rangeStroke));
        yaxis.setColour(rangeColor);
        yaxis.setGridColour(rangeGridColor);
        this.chart.setYAxis(yaxis);
        return yaxis;
    }

    public void setupOnclick() {
        Node urlTemplateNode = this.chartNode.selectSingleNode(URL_TEMPLATE_NODE_LOC);
        if (AbstractChartFactory.getValue(urlTemplateNode) != null) {
            this.baseURLTemplate = AbstractChartFactory.getValue(urlTemplateNode);
        }
    }

    @Override
    public void setData(IPentahoResultSet data) {
        block3: {
            this.hasRowHeaders = data.getMetaData().getRowHeaders() != null;
            boolean bl = this.hasColumnHeaders = data.getMetaData().getColumnHeaders() != null;
            if (!this.hasRowHeaders || !this.hasColumnHeaders) {
                data = PentahoDataTransmuter.transmute((IPentahoResultSet)data, (boolean)false);
            }
            try {
                this.rowHeaders = PentahoDataTransmuter.getCollapsedHeaders((int)1, (IPentahoResultSet)data, (char)'|');
                this.columnHeaders = PentahoDataTransmuter.getCollapsedHeaders((int)0, (IPentahoResultSet)data, (char)'|');
            }
            catch (Exception e) {
                if (this.log == null) break block3;
                this.log.error(null, (Throwable)e);
            }
        }
        this.data = data;
    }

    protected int getColumnCount() {
        if (!this.hasRowHeaders) {
            return this.data.getColumnCount() - 1;
        }
        return this.data.getColumnCount();
    }

    protected int getRowCount() {
        if (!this.hasColumnHeaders) {
            return this.data.getRowCount() - 1;
        }
        return this.data.getRowCount();
    }

    protected String getRowHeader(int r) {
        if (!this.hasColumnHeaders) {
            ++r;
        }
        return this.rowHeaders[r];
    }

    protected String getColumnHeader(int c) {
        if (!this.hasRowHeaders) {
            ++c;
        }
        return this.columnHeaders[c];
    }

    protected Object getValueAt(int r, int c) {
        if (!this.hasRowHeaders) {
            ++c;
        }
        if (!this.hasColumnHeaders) {
            ++r;
        }
        return this.data.getValueAt(r, c);
    }

    protected String buildCSSStringFromNode(Node n) {
        String fontFamily = AbstractChartFactory.getNodeValue(n, FONT_FAMILY_NODE_LOC);
        String fontSize = AbstractChartFactory.getNodeValue(n, FONT_SIZE_NODE_LOC);
        String fontWeight = null;
        if ("true".equals(AbstractChartFactory.getNodeValue(n, FONT_BOLD_NODE_LOC))) {
            fontWeight = "bold";
        }
        String fontStyle = null;
        if ("true".equals(AbstractChartFactory.getNodeValue(n, FONT_ITALIC_NODE_LOC))) {
            fontStyle = "italic";
        }
        return this.buildCSSString(fontFamily, fontSize, fontWeight, fontStyle);
    }

    protected String buildCSSString(String fontfamily, String fontsize, String fontweight, String fontstyle) {
        Properties props = new Properties();
        props.put("fontfamily", fontfamily != null ? fontfamily : CSS_FONT_FAMILY_DEFAULT);
        props.put("fontsize", fontsize != null ? fontsize : CSS_FONT_SIZE_DEFAULT);
        props.put("fontweight", fontweight != null ? fontweight : "normal");
        props.put("fontstyle", fontstyle != null ? fontstyle : "normal");
        return TemplateUtil.applyTemplate((String)CSS_FONT_STYLES, (Properties)props, null);
    }

    protected String getColor(int i) {
        return this.colors.get(i % this.colors.size());
    }

    public static String getNodeValue(Node parent, String node) {
        if (parent == null) {
            return null;
        }
        Node textNode = parent.selectSingleNode(node);
        return AbstractChartFactory.getValue(textNode);
    }

    public static String getValue(Node n) {
        if (n != null && n.getText() != null && n.getText().length() > 0) {
            return n.getText().trim();
        }
        return null;
    }

    public static class MinMax {
        int min;
        int max;

        public MinMax(int min, int max) {
            this.min = min;
            this.max = max;
        }
    }
}

