/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.olap;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import mondrian.olap.Util;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.plugin.action.olap.IOlapService;
import org.pentaho.platform.util.PasswordHelper;
import org.pentaho.platform.util.logging.Logger;

public class Olap4jSystemListener
implements IPentahoSystemListener {
    private static final String PASSWORD = "password";
    private List<Properties> olap4jConnectionList;
    private List<String> removeList;
    private boolean isSecured = false;

    public boolean startup(IPentahoSession session) {
        try {
            if (PentahoSystem.get(IUserRoleListService.class) != null) {
                this.isSecured = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IOlapService olapService = this.getOlapService(session);
        if (olapService != null) {
            this.addCatalogs(olapService);
            this.removeCatalogs(olapService);
        }
        return true;
    }

    private void removeCatalogs(final IOlapService olapService) {
        for (final String catalogName : this.removeList) {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    olapService.removeCatalog(catalogName, PentahoSessionHolder.getSession());
                    return null;
                }
            };
            try {
                if (this.isSecured) {
                    SecurityHelper.getInstance().runAsSystem((Callable)callable);
                    continue;
                }
                callable.call();
            }
            catch (Exception e) {
                Logger.warn((Object)this, (String)Messages.getInstance().getString("Olap4jSystemListener.ERROR_00002_REMOVE_ERROR", new Object[]{catalogName}), (Throwable)e);
            }
        }
    }

    private void addCatalogs(final IOlapService olapService) {
        for (final Properties properties : this.olap4jConnectionList) {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    String password = properties.getProperty(Olap4jSystemListener.PASSWORD);
                    olapService.addOlap4jCatalog(properties.getProperty("name"), properties.getProperty("className"), Olap4jSystemListener.this.getConnectString(properties), properties.getProperty("user"), password == null ? null : Olap4jSystemListener.this.getPassword(password), new Properties(), true, PentahoSessionHolder.getSession());
                    return null;
                }
            };
            try {
                if (this.isSecured) {
                    SecurityHelper.getInstance().runAsSystem((Callable)callable);
                    continue;
                }
                callable.call();
            }
            catch (Exception e) {
                Logger.warn((Object)this, (String)Messages.getInstance().getString("Olap4jSystemListener.ERROR_00001_ADD_ERROR", new Object[]{properties.getProperty("name")}), (Throwable)e);
            }
        }
    }

    private String getConnectString(Properties properties) {
        String connectString = properties.getProperty("connectString");
        Util.PropertyList connectMap = Util.parseConnectString((String)connectString);
        if (connectMap.get(PASSWORD) != null) {
            connectMap.put(PASSWORD, this.getPassword(connectMap.get(PASSWORD)));
        }
        return connectMap.toString();
    }

    private String getPassword(String password) {
        return this.getPasswordHelper().getPassword(password);
    }

    PasswordHelper getPasswordHelper() {
        return new PasswordHelper();
    }

    IOlapService getOlapService(IPentahoSession session) {
        return (IOlapService)PentahoSystem.get(IOlapService.class, (IPentahoSession)session);
    }

    public void shutdown() {
    }

    public void setOlap4jConnectionList(List<Properties> olap4jConnectionList) {
        this.olap4jConnectionList = olap4jConnectionList;
    }

    public void setOlap4jConnectionRemoveList(List<String> removeList) {
        this.removeList = removeList;
    }
}

