/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.kettle;

import com.google.common.base.Throwables;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.www.SlaveServerConfig;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.stores.delegate.DelegatingMetaStore;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DIServerConfig
extends SlaveServerConfig {
    public static final String SINGLE_DI_SERVER_INSTANCE = "singleDiServerInstance";
    public static final String PUR_REPOSITORY_PLUGIN_ID = "PentahoEnterpriseRepository";
    private RepositoryMeta repositoryMeta;
    private final PluginRegistry pluginRegistry;

    public DIServerConfig(LogChannel logChannel, Node configNode) throws KettleXMLException {
        this(logChannel, configNode, PluginRegistry.getInstance());
    }

    public DIServerConfig(LogChannel logChannel, Node configNode, PluginRegistry pluginRegistry) throws KettleXMLException {
        super((LogChannelInterface)logChannel, configNode);
        this.pluginRegistry = pluginRegistry;
    }

    public Repository getRepository() throws KettleException {
        Repository repository = super.getRepository();
        if (repository == null && this.repositoryInProcess()) {
            try {
                repository = this.connectInProcessRepository();
            }
            catch (Exception e) {
                Logger.warn((Object)((Object)this), (String)e.getMessage(), (Throwable)e);
                repository = null;
            }
        }
        return repository;
    }

    public DelegatingMetaStore getMetaStore() {
        DelegatingMetaStore metaStore = super.getMetaStore();
        try {
            Repository inProcessRepository;
            Repository configuredRepository = super.getRepository();
            if (configuredRepository == null && this.repositoryInProcess() && (inProcessRepository = this.connectInProcessRepository()) != null) {
                metaStore = new DelegatingMetaStore(new IMetaStore[]{inProcessRepository.getMetaStore()});
                metaStore.setActiveMetaStoreName(inProcessRepository.getMetaStore().getName());
            }
        }
        catch (Exception e) {
            Logger.warn((Object)((Object)this), (String)e.getMessage(), (Throwable)e);
            metaStore = super.getMetaStore();
        }
        return metaStore;
    }

    private boolean repositoryInProcess() {
        return PentahoSystem.getApplicationContext() != null && "true".equals(PentahoSystem.getSystemSetting((String)SINGLE_DI_SERVER_INSTANCE, (String)"true"));
    }

    private Repository connectInProcessRepository() throws KettleException {
        Repository repository = null;
        IPentahoSession user = PentahoSessionHolder.getSession();
        if (user != null) {
            repository = (Repository)this.pluginRegistry.loadClass(RepositoryPluginType.class, PUR_REPOSITORY_PLUGIN_ID, Repository.class);
            try {
                repository.init(this.getRepositoryMeta());
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, KettleException.class);
                throw new KettleException((Throwable)e);
            }
            repository.connect(user.getName(), "");
        }
        return repository;
    }

    private RepositoryMeta getRepositoryMeta() throws KettleException, ParserConfigurationException {
        if (this.repositoryMeta == null) {
            RepositoryMeta repositoryMeta = (RepositoryMeta)this.pluginRegistry.loadClass(RepositoryPluginType.class, PUR_REPOSITORY_PLUGIN_ID, RepositoryMeta.class);
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element repnode = document.createElement("repository");
            Element id = document.createElement("id");
            id.setTextContent(PUR_REPOSITORY_PLUGIN_ID);
            repnode.appendChild(id);
            Element name = document.createElement("name");
            name.setTextContent(SINGLE_DI_SERVER_INSTANCE);
            repnode.appendChild(name);
            Element description = document.createElement("description");
            description.setTextContent(SINGLE_DI_SERVER_INSTANCE);
            repnode.appendChild(description);
            Element location = document.createElement("repository_location_url");
            location.setTextContent(PentahoSystem.getApplicationContext().getFullyQualifiedServerURL());
            repnode.appendChild(location);
            repositoryMeta.loadXML((Node)repnode, Collections.emptyList());
            this.repositoryMeta = repositoryMeta;
        }
        return this.repositoryMeta;
    }
}

