/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.config.AppConfigException;
import org.pentaho.platform.config.ConsoleConfigXml;
import org.pentaho.platform.config.HibernateSettingsXml;
import org.pentaho.platform.config.IConsoleConfig;
import org.pentaho.platform.config.PasswordServiceFactory;
import org.pentaho.platform.config.PentahoObjectsConfig;
import org.pentaho.platform.config.SpringSecurityHibernateConfig;
import org.pentaho.platform.config.WebXml;
import org.pentaho.platform.config.i18n.Messages;
import org.springframework.security.authentication.encoding.PasswordEncoder;

public class AppConfigProperties {
    public static final String CONFIG_FILE_NAME = "console.xml";
    public static final String WEB_XML_PATH = "/WEB-INF/web.xml";
    public static final String HIBERNATE_MANAGED_XML_PATH = "/system/hibernate/hibernate-settings.xml";
    public static final String PENTAHO_OBJECTS_SPRING_XML = "/system/pentahoObjects.spring.xml";
    public static final String SPRING_SECURITY_HIBERNATE_XML = "/system/applicationContext-spring-security-hibernate.xml";
    public static final String JDBC_DRIVER_PATH = "./jdbc";
    public static final String KEY_BISERVER_STATUS_CHECK_PERIOD = "biserver-status-check-period";
    public static final String KEY_BISERVER_BASE_URL = "biserver-base-url";
    public static final String KEY_BISERVER_CONTEXT_PATH = "biserver-context-path";
    public static final String KEY_PLATFORM_USERNAME = "platform-username";
    public static final String DEFAULT_VALUE_PASSWORD_SERVICE_CLASS = "org.pentaho.platform.util.KettlePasswordService";
    public static final String DEFAULT_BISERVER_BASE_URL = "http://localhost:8080/pentaho";
    public static final String DEFAULT_BISERVER_CONTEXT_PATH = "/pentaho";
    public static final String DEFAULT_PLATFORM_USERNAME = "admin";
    public static final String DEFAULT_BISERVER_STATUS_CHECK_PERIOD = "30000";
    public static final String DEFAULT_HOMEPAGE_TIMEOUT = "15000";
    public static final String DEFAULT_HIBERNATE_CONFIG_PATH = "system/hibernate/hsql.hibernate.cfg.xml";
    public static final String DEFAULT_HELP_URL = "http://wiki.pentaho.com/display/ServerDoc2x/The+Pentaho+Administration+Console";
    public static final String DEFAULT_HOMEPAGE_URL = "http://www.pentaho.com/console_home";
    private IConsoleConfig consoleConfig = null;
    private HibernateSettingsXml hibernateSettingXml = null;
    private PentahoObjectsConfig pentahoObjectsConfig = null;
    private static SpringSecurityHibernateConfig springSecurityHibernateConfig = null;
    private static AppConfigProperties instance = new AppConfigProperties();
    private static final Log logger = LogFactory.getLog(AppConfigProperties.class);

    protected AppConfigProperties() {
    }

    public static synchronized AppConfigProperties getInstance() {
        return instance;
    }

    public void refreshConfig() throws AppConfigException {
        this.consoleConfig = null;
        this.hibernateSettingXml = null;
        this.pentahoObjectsConfig = null;
        try {
            PasswordServiceFactory.init(this.getPasswordServiceClass());
        }
        catch (Exception e) {
            throw new AppConfigException(Messages.getErrorString("AppConfigProperties.ERROR_0004_UNABLE_TO_READ_FILE", this.getSolutionPath() + PENTAHO_OBJECTS_SPRING_XML), e);
        }
    }

    private String getDefaultInstallDir() {
        String defaultInstallDir = "./..";
        if (this.getConsoleConfig().getDefaultBiServerDir() != null && this.getConsoleConfig().getDefaultBiServerDir().trim().length() > 0) {
            defaultInstallDir = defaultInstallDir + "/" + this.getConsoleConfig().getDefaultBiServerDir();
        }
        return defaultInstallDir;
    }

    public boolean isValidConfiguration() {
        File warPathFile;
        boolean solutionPathValid = false;
        boolean warPathValid = false;
        File solutionPathFile = new File(this.getSolutionPath());
        if (solutionPathFile != null && solutionPathFile.isDirectory()) {
            solutionPathValid = true;
        }
        if ((warPathFile = new File(this.getWarPath())) != null && warPathFile.isDirectory()) {
            warPathValid = true;
        }
        return solutionPathValid && warPathValid;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.getSpringSecurityHibernateConfig().getPasswordEncoder();
    }

    public String getPlatformUsername() {
        String platormUserName = this.getConsoleConfig().getPlatformUserName();
        if (platormUserName == null || platormUserName.trim().length() == 0) {
            platormUserName = DEFAULT_PLATFORM_USERNAME;
        }
        return platormUserName;
    }

    public String getBiServerContextPath() {
        int start;
        int middle;
        String baseUrl = this.getBiServerBaseUrl();
        String biserverContextPath = baseUrl.substring(middle = baseUrl.indexOf("/", start = baseUrl.lastIndexOf(":")), baseUrl.length() - 1);
        if (biserverContextPath == null || biserverContextPath.length() <= 0) {
            biserverContextPath = DEFAULT_BISERVER_CONTEXT_PATH;
        }
        return biserverContextPath;
    }

    public String getBiServerBaseUrl() {
        String baseUrl = DEFAULT_BISERVER_BASE_URL;
        String consoleXmlBaseUrl = this.getConsoleConfig().getBaseUrl();
        if (consoleXmlBaseUrl != null) {
            return consoleXmlBaseUrl;
        }
        try {
            WebXml webXml = new WebXml(new File(this.getWarPath() + WEB_XML_PATH));
            baseUrl = webXml.getBaseUrl();
            if (baseUrl == null || baseUrl.length() <= 0) {
                baseUrl = DEFAULT_BISERVER_BASE_URL;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baseUrl;
    }

    public String getBiServerStatusCheckPeriod() {
        Long period = this.getConsoleConfig().getServerStatusCheckPeriod();
        return period != null ? period.toString() : DEFAULT_BISERVER_STATUS_CHECK_PERIOD;
    }

    public String getDefaultRolesString() {
        return this.getConsoleConfig().getDefaultRoles();
    }

    public List<String> getDefaultRoles() {
        String defaultRolesString = this.getDefaultRolesString();
        ArrayList<String> defaultRoles = new ArrayList<String>();
        if (defaultRolesString != null && defaultRolesString.trim().length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(defaultRolesString, ",");
            while (tokenizer.hasMoreTokens()) {
                defaultRoles.add(tokenizer.nextToken());
            }
        }
        return defaultRoles;
    }

    public String getHomepageUrl() {
        String homepageUrl = this.getConsoleConfig().getHomePageUrl();
        if (homepageUrl == null || homepageUrl.trim().length() == 0) {
            homepageUrl = DEFAULT_HOMEPAGE_URL;
        }
        return homepageUrl;
    }

    public String getHomepageTimeout() {
        Integer timeout = this.getConsoleConfig().getHomePageTimeout();
        return timeout != null ? timeout.toString() : DEFAULT_HOMEPAGE_TIMEOUT;
    }

    public String getHibernateConfigPath() {
        String hibernateConfigPath = DEFAULT_HIBERNATE_CONFIG_PATH;
        String hibernateConfigFile = this.getHibernateSettingsXml().getHibernateConfigFile();
        if (hibernateConfigFile != null && hibernateConfigFile.length() > 0) {
            hibernateConfigPath = hibernateConfigFile;
        }
        return hibernateConfigPath;
    }

    public boolean isHibernateManaged() {
        return this.getHibernateSettingsXml().getHibernateManaged();
    }

    public String getSolutionPath() {
        String pentahoSolutionPath = this.getConsoleConfig().getSolutionPath();
        if (pentahoSolutionPath == null || pentahoSolutionPath.trim().length() == 0) {
            pentahoSolutionPath = this.getDefaultInstallDir() + "/pentaho-solutions";
        }
        return pentahoSolutionPath;
    }

    public String getWarPath() {
        String pentahoWarPath = this.getConsoleConfig().getWebAppPath();
        if (pentahoWarPath == null || pentahoWarPath.trim().length() == 0) {
            pentahoWarPath = this.getDefaultInstallDir() + "/tomcat/webapps/pentaho";
        }
        return pentahoWarPath;
    }

    public String getPasswordServiceClass() {
        String passwordServiceClass = this.getPentahoObjectsConfig().getPasswordService();
        if (StringUtils.isEmpty((String)passwordServiceClass)) {
            passwordServiceClass = DEFAULT_VALUE_PASSWORD_SERVICE_CLASS;
        }
        return passwordServiceClass;
    }

    public String getJdbcDriverPath() {
        return JDBC_DRIVER_PATH;
    }

    public String getHelpUrl() {
        String helpUrl = this.getConsoleConfig().getHelpUrl();
        if (helpUrl == null || helpUrl.trim().length() == 0) {
            helpUrl = DEFAULT_HELP_URL;
        }
        return helpUrl;
    }

    IConsoleConfig getConsoleConfig() {
        if (this.consoleConfig == null) {
            try {
                this.consoleConfig = new ConsoleConfigXml(new File(ClassLoader.getSystemResource(CONFIG_FILE_NAME).toURI()));
            }
            catch (Exception ex) {
                logger.warn((Object)Messages.getErrorString("AppConfigProperties.ERROR_0004_UNABLE_TO_READ_FILE", CONFIG_FILE_NAME));
                this.consoleConfig = new ConsoleConfigXml();
            }
        }
        return this.consoleConfig;
    }

    HibernateSettingsXml getHibernateSettingsXml() {
        if (this.hibernateSettingXml == null) {
            try {
                this.hibernateSettingXml = new HibernateSettingsXml(new File(this.getSolutionPath() + HIBERNATE_MANAGED_XML_PATH));
            }
            catch (Exception e) {
                this.hibernateSettingXml = new HibernateSettingsXml();
            }
        }
        return this.hibernateSettingXml;
    }

    PentahoObjectsConfig getPentahoObjectsConfig() {
        if (this.pentahoObjectsConfig == null) {
            try {
                this.pentahoObjectsConfig = new PentahoObjectsConfig(new File(this.getSolutionPath() + PENTAHO_OBJECTS_SPRING_XML));
            }
            catch (Exception e) {
                this.pentahoObjectsConfig = new PentahoObjectsConfig();
            }
        }
        return this.pentahoObjectsConfig;
    }

    SpringSecurityHibernateConfig getSpringSecurityHibernateConfig() {
        if (springSecurityHibernateConfig == null) {
            try {
                springSecurityHibernateConfig = new SpringSecurityHibernateConfig(new File(this.getSolutionPath() + SPRING_SECURITY_HIBERNATE_XML));
            }
            catch (Exception e) {
                logger.warn((Object)Messages.getErrorString("AppConfigProperties.ERROR_0004_UNABLE_TO_READ_FILE", this.getSolutionPath() + SPRING_SECURITY_HIBERNATE_XML));
                springSecurityHibernateConfig = new SpringSecurityHibernateConfig();
            }
        }
        return springSecurityHibernateConfig;
    }
}

