/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.system.commands;

import jline.console.ConsoleReader;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.system.SystemService;
import org.apache.karaf.system.commands.AbstractSystemAction;

@Command(scope="system", name="shutdown", description="Shutdown the Karaf container.")
public class Shutdown
extends AbstractSystemAction {
    @Option(name="-f", aliases={"--force"}, description="Force the shutdown without confirmation message.", required=false, multiValued=false)
    boolean force = false;
    @Option(name="-r", aliases={"--reboot"}, description="Reboot the Karaf container.", required=false, multiValued=false)
    boolean reboot = false;
    @Option(name="-h", aliases={"--halt"}, description="Halt the Karaf container.", required=false, multiValued=false)
    boolean halt = false;
    @Option(name="-c", aliases={"--clean", "--clean-all", "-ca"}, description="Force a clean restart by deleting the data directory")
    private boolean cleanAll;
    @Option(name="-cc", aliases={"--clean-cache", "-cc"}, description="Force a clean restart by deleting the cache directory")
    private boolean cleanCache;
    @Argument(name="time", index=0, description="Shutdown after a specified delay. The time argument can have different formats. First, it can be an absolute time in the format hh:mm, in which hh is the hour (1 or 2 digits) and mm is the minute of the hour (in two digits). Second, it can be in the format m (or +m), in which m is the number of minutes to wait. The word now is an alias for 0 (or +0).", required=false, multiValued=false)
    String time;

    protected Object doExecute() throws Exception {
        if (this.force) {
            if (this.reboot) {
                this.systemService.reboot(this.time, this.determineSwipeType());
            } else {
                this.systemService.halt(this.time);
            }
            return null;
        }
        String karafName = System.getProperty("karaf.name");
        String msg = this.reboot ? String.format("Confirm: reboot instance %s (yes/no): ", karafName) : String.format("Confirm: halt instance %s (yes/no): ", karafName);
        ConsoleReader reader = (ConsoleReader)this.session.get(".jline.reader");
        String str = reader.readLine(msg);
        if (str.equalsIgnoreCase("yes")) {
            if (this.reboot) {
                this.systemService.reboot(this.time, this.determineSwipeType());
            } else {
                this.systemService.halt(this.time);
            }
        }
        return null;
    }

    private SystemService.Swipe determineSwipeType() {
        if (this.cleanAll) {
            return SystemService.Swipe.ALL;
        }
        if (this.cleanCache) {
            return SystemService.Swipe.CACHE;
        }
        return SystemService.Swipe.NONE;
    }
}

