/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.security;

import java.util.List;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.pms.schema.security.SecurityACL;
import org.pentaho.pms.schema.security.SecurityService;
import org.pentaho.pms.util.Const;

public class SecurityReference {
    private SecurityService securityService = new SecurityService();

    public SecurityReference() {
    }

    public String getRightsDescription(int rights) {
        List<SecurityACL> acls = this.securityService.getAcls();
        StringBuffer desc = new StringBuffer();
        boolean first = true;
        boolean nothing = true;
        for (int i = 0; i < acls.size(); ++i) {
            SecurityACL acl = acls.get(i);
            if ((rights & acl.getMask()) != acl.getMask() || acl.getMask() <= 0) continue;
            if (!first) {
                desc.append(", ");
            }
            desc.append(acl.getName());
            first = false;
            nothing = false;
        }
        if (nothing) {
            SecurityACL nothingAcl;
            try {
                nothingAcl = this.findAcl(0);
            }
            catch (Exception e) {
                nothingAcl = null;
            }
            if (nothingAcl != null) {
                desc = new StringBuffer(nothingAcl.getName());
            }
        }
        return desc.toString();
    }

    private SecurityACL findAcl(int mask) throws Exception {
        List<SecurityACL> acls = this.securityService.getAcls();
        for (int i = 0; i < acls.size(); ++i) {
            SecurityACL acl = acls.get(i);
            if (acl.getMask() != mask) continue;
            return acl;
        }
        return null;
    }

    public SecurityACL findAcl(String name) {
        List<SecurityACL> acls = this.securityService.getAcls();
        for (int i = 0; i < acls.size(); ++i) {
            SecurityACL acl = acls.get(i);
            if (!acl.getName().equals(name)) continue;
            return acl;
        }
        return null;
    }

    public SecurityReference(SecurityService securityService) throws Exception {
        this();
        this.securityService = securityService;
    }

    public String toXML() throws Exception {
        int i;
        List<String> users = this.securityService.getUsers();
        List<String> roles = this.securityService.getRoles();
        StringBuffer xml = new StringBuffer();
        xml.append("<content>").append(Const.CR);
        xml.append("  <users>").append(Const.CR);
        for (i = 0; i < users.size(); ++i) {
            xml.append("    ").append(XMLHandler.addTagValue((String)"user", (String)users.get(i)));
        }
        xml.append("  </users>").append(Const.CR);
        xml.append("  <roles>").append(Const.CR);
        for (i = 0; i < roles.size(); ++i) {
            xml.append("    ").append(XMLHandler.addTagValue((String)"role", (String)roles.get(i)));
        }
        xml.append("  </roles>").append(Const.CR);
        xml.append("</content>").append(Const.CR);
        return xml.toString();
    }

    public List<SecurityACL> getAcls() {
        return this.securityService.getAcls();
    }

    public List<String> getRoles() {
        return this.securityService.getRoles();
    }

    public List<String> getUsers() {
        return this.securityService.getUsers();
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }
}

