/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema;

import java.util.List;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.schema.BusinessColumn;
import org.pentaho.pms.schema.BusinessModel;
import org.pentaho.pms.schema.BusinessTable;
import org.pentaho.pms.schema.RelationshipMeta;
import org.pentaho.pms.schema.concept.types.aggregation.AggregationSettings;
import org.pentaho.pms.schema.concept.types.datatype.DataTypeSettings;
import org.pentaho.pms.schema.olap.OlapCube;
import org.pentaho.pms.schema.olap.OlapDimension;
import org.pentaho.pms.schema.olap.OlapDimensionUsage;
import org.pentaho.pms.schema.olap.OlapHierarchy;
import org.pentaho.pms.schema.olap.OlapHierarchyLevel;
import org.pentaho.pms.schema.olap.OlapMeasure;
import org.pentaho.pms.util.Const;

public class MondrianModelExporter {
    private BusinessModel businessModel;
    private String locale;

    public MondrianModelExporter(BusinessModel businessModel, String locale) {
        this.businessModel = businessModel;
        this.locale = locale;
    }

    public String createMondrianModelXML() throws Exception {
        StringBuilder xml = new StringBuilder(10000);
        xml.append("<Schema ");
        xml.append("name=\"");
        XMLHandler.appendReplacedChars((StringBuilder)xml, (String)this.businessModel.getDisplayName(this.locale));
        xml.append("\">");
        xml.append(Const.CR);
        List<OlapDimension> olapDimensions = this.businessModel.getOlapDimensions();
        for (int d = 0; d < olapDimensions.size(); ++d) {
            OlapDimension olapDimension = olapDimensions.get(d);
            xml.append("  <Dimension");
            xml.append(" name=\"");
            XMLHandler.appendReplacedChars((StringBuilder)xml, (String)olapDimension.getName());
            xml.append("\"");
            if (olapDimension.isTimeDimension()) {
                xml.append(" type=\"");
                XMLHandler.appendReplacedChars((StringBuilder)xml, (String)"TimeDimension");
                xml.append("\"");
            }
            xml.append(">");
            xml.append(Const.CR);
            List<OlapHierarchy> olapHierarchies = olapDimension.getHierarchies();
            for (int h = 0; h < olapHierarchies.size(); ++h) {
                OlapHierarchy olapHierarchy = olapHierarchies.get(h);
                xml.append("    <Hierarchy");
                xml.append(" hasAll=\"");
                xml.append(olapHierarchy.isHavingAll() ? "true" : "false");
                xml.append("\"");
                if (olapHierarchy.getPrimaryKey() != null) {
                    xml.append(" primaryKey=\"");
                    xml.append(olapHierarchy.getPrimaryKey().getFormula());
                    xml.append("\"");
                }
                xml.append(">");
                xml.append(Const.CR);
                xml.append("      <Table");
                xml.append(" name=\"");
                XMLHandler.appendReplacedChars((StringBuilder)xml, (String)olapHierarchy.getBusinessTable().getTargetTable());
                xml.append("\"");
                xml.append("/>");
                xml.append(Const.CR);
                List<OlapHierarchyLevel> hierarchyLevels = olapHierarchy.getHierarchyLevels();
                for (int hl = 0; hl < hierarchyLevels.size(); ++hl) {
                    OlapHierarchyLevel olapHierarchyLevel = hierarchyLevels.get(hl);
                    xml.append("      <Level");
                    xml.append(" name=\"");
                    XMLHandler.appendReplacedChars((StringBuilder)xml, (String)olapHierarchyLevel.getName());
                    xml.append("\"");
                    xml.append(" column=\"");
                    XMLHandler.appendReplacedChars((StringBuilder)xml, (String)olapHierarchyLevel.getReferenceColumn().getFormula());
                    xml.append("\"");
                    xml.append(" uniqueMembers=\"");
                    XMLHandler.appendReplacedChars((StringBuilder)xml, (String)(olapHierarchyLevel.isHavingUniqueMembers() ? "true" : "false"));
                    xml.append("\"");
                    xml.append(">");
                    xml.append(Const.CR);
                    List<BusinessColumn> businessColumns = olapHierarchyLevel.getBusinessColumns();
                    for (int i = 0; i < businessColumns.size(); ++i) {
                        BusinessColumn businessColumn = businessColumns.get(i);
                        xml.append("        <Property");
                        xml.append(" name=\"");
                        XMLHandler.appendReplacedChars((StringBuilder)xml, (String)businessColumn.getDisplayName(this.locale));
                        xml.append("\"");
                        xml.append(" column=\"");
                        XMLHandler.appendReplacedChars((StringBuilder)xml, (String)businessColumn.getFormula());
                        xml.append("\"");
                        DataTypeSettings dataType = businessColumn.getDataType();
                        String typeDesc = null;
                        switch (dataType.getType()) {
                            case 1: {
                                typeDesc = "String";
                                break;
                            }
                            case 4: {
                                typeDesc = "Numeric";
                                break;
                            }
                            case 3: {
                                typeDesc = "Boolean";
                                break;
                            }
                            case 2: {
                                typeDesc = "Date";
                            }
                        }
                        if (typeDesc != null) {
                            xml.append(" type=\"");
                            XMLHandler.appendReplacedChars((StringBuilder)xml, (String)typeDesc);
                            xml.append("\"");
                        }
                        xml.append("/>");
                        xml.append(Const.CR);
                    }
                    xml.append("      </Level>").append(Const.CR);
                }
                xml.append("    </Hierarchy>").append(Const.CR);
            }
            xml.append("  </Dimension>").append(Const.CR);
        }
        List<OlapCube> olapCubes = this.businessModel.getOlapCubes();
        for (int c = 0; c < olapCubes.size(); ++c) {
            OlapCube olapCube = olapCubes.get(c);
            xml.append("  <Cube");
            xml.append(" name=\"");
            XMLHandler.appendReplacedChars((StringBuilder)xml, (String)olapCube.getName());
            xml.append("\"");
            xml.append(">").append(Const.CR);
            xml.append("    <Table");
            xml.append(" name=\"");
            XMLHandler.appendReplacedChars((StringBuilder)xml, (String)olapCube.getBusinessTable().getTargetTable());
            xml.append("\"");
            xml.append("/>").append(Const.CR);
            List<OlapDimensionUsage> usages = olapCube.getOlapDimensionUsages();
            for (int u = 0; u < usages.size(); ++u) {
                OlapDimensionUsage usage = usages.get(u);
                xml.append("    <DimensionUsage");
                xml.append(" name=\"");
                XMLHandler.appendReplacedChars((StringBuilder)xml, (String)usage.getName());
                xml.append("\"");
                xml.append(" source=\"");
                XMLHandler.appendReplacedChars((StringBuilder)xml, (String)usage.getOlapDimension().getName());
                xml.append("\"");
                BusinessTable dimTable = usage.getOlapDimension().findBusinessTable();
                BusinessTable cubeTable = olapCube.getBusinessTable();
                RelationshipMeta relationshipMeta = this.businessModel.findRelationshipUsing(dimTable, cubeTable);
                if (!dimTable.equals(cubeTable) || relationshipMeta != null) {
                    if (relationshipMeta != null) {
                        BusinessColumn keyColumn = relationshipMeta.getTableFrom().equals(dimTable) ? relationshipMeta.getFieldTo() : relationshipMeta.getFieldFrom();
                        xml.append(" foreignKey=\"");
                        XMLHandler.appendReplacedChars((StringBuilder)xml, (String)keyColumn.getFormula());
                        xml.append("\"");
                    } else {
                        throw new Exception(Messages.getString("MondrianModelExporter.ERROR_0001_ERROR_NO_RELATIONSHIP", dimTable.getDisplayName(this.locale), cubeTable.toString()));
                    }
                }
                xml.append("/>").append(Const.CR);
            }
            List<OlapMeasure> measures = olapCube.getOlapMeasures();
            for (int m = 0; m < measures.size(); ++m) {
                String formatString;
                OlapMeasure measure = measures.get(m);
                BusinessColumn businessColumn = measure.getBusinessColumn();
                xml.append("    <Measure");
                xml.append(" name=\"");
                XMLHandler.appendReplacedChars((StringBuilder)xml, (String)businessColumn.getDisplayName(this.locale));
                xml.append("\"");
                xml.append(" column=\"");
                XMLHandler.appendReplacedChars((StringBuilder)xml, (String)businessColumn.getFormula());
                xml.append("\"");
                AggregationSettings aggregationType = businessColumn.getAggregationType();
                String typeDesc = null;
                switch (aggregationType.getType()) {
                    case 0: {
                        typeDesc = "none";
                        break;
                    }
                    case 1: {
                        typeDesc = "sum";
                        break;
                    }
                    case 2: {
                        typeDesc = "avg";
                        break;
                    }
                    case 3: {
                        typeDesc = "count";
                        break;
                    }
                    case 4: {
                        typeDesc = "distinct count";
                        break;
                    }
                    case 5: {
                        typeDesc = "min";
                        break;
                    }
                    case 6: {
                        typeDesc = "max";
                    }
                }
                if (typeDesc != null) {
                    xml.append(" aggregator=\"");
                    XMLHandler.appendReplacedChars((StringBuilder)xml, (String)typeDesc);
                    xml.append("\"");
                }
                if (Const.isEmpty(formatString = businessColumn.getMask())) {
                    formatString = "Standard";
                }
                xml.append(" formatString=\"");
                XMLHandler.appendReplacedChars((StringBuilder)xml, (String)formatString);
                xml.append("\"");
                xml.append("/>").append(Const.CR);
            }
            xml.append("  </Cube>").append(Const.CR);
        }
        xml.append("</Schema>");
        return xml.toString();
    }

    public BusinessModel getBusinessModel() {
        return this.businessModel;
    }

    public void setBusinessModel(BusinessModel businessModel) {
        this.businessModel = businessModel;
    }
}

