/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.model.olap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.olap.OlapHierarchy;

public class OlapDimension
implements Cloneable,
Serializable {
    public static final String TYPE_TIME_DIMENSION = "TimeDimension";
    public static final String TYPE_STANDARD_DIMENSION = "StandardDimension";
    private String name;
    private String type = "StandardDimension";
    private List<OlapHierarchy> hierarchies = new ArrayList<OlapHierarchy>();

    public Object clone() {
        OlapDimension olapDimension = new OlapDimension();
        olapDimension.name = this.name;
        olapDimension.type = this.type;
        for (int i = 0; i < this.hierarchies.size(); ++i) {
            OlapHierarchy hierarchy = this.hierarchies.get(i);
            olapDimension.hierarchies.add((OlapHierarchy)hierarchy.clone());
        }
        return olapDimension;
    }

    public boolean equals(Object obj) {
        return this.name.equals(((OlapDimension)obj).getName());
    }

    public List<OlapHierarchy> getHierarchies() {
        return this.hierarchies;
    }

    public void setHierarchies(List<OlapHierarchy> hierarchies) {
        this.hierarchies = hierarchies;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isTimeDimension() {
        return TYPE_TIME_DIMENSION.equals(this.type);
    }

    public void setTimeDimension(boolean timeDimension) {
        this.type = timeDimension ? TYPE_TIME_DIMENSION : TYPE_STANDARD_DIMENSION;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public OlapHierarchy findOlapHierarchy(String thisName) {
        for (int i = 0; i < this.hierarchies.size(); ++i) {
            OlapHierarchy hierarchy = this.hierarchies.get(i);
            if (!hierarchy.getName().equalsIgnoreCase(thisName)) continue;
            return hierarchy;
        }
        return null;
    }

    public LogicalTable findLogicalTable() {
        for (int i = 0; i < this.hierarchies.size(); ++i) {
            OlapHierarchy hierarchy = this.hierarchies.get(i);
            if (hierarchy.getLogicalTable() == null) continue;
            return hierarchy.getLogicalTable();
        }
        return null;
    }
}

