/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.configuration.impl.spark;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pentaho.di.engine.configuration.api.RunConfiguration;
import org.pentaho.di.engine.configuration.api.RunConfigurationExecutor;
import org.pentaho.di.engine.configuration.api.RunConfigurationProvider;
import org.pentaho.di.engine.configuration.impl.MetaStoreRunConfigurationFactory;
import org.pentaho.di.engine.configuration.impl.spark.SparkRunConfiguration;
import org.pentaho.di.engine.configuration.impl.spark.SparkRunConfigurationExecutor;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.persist.MetaStoreFactory;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;

public class SparkRunConfigurationProvider
extends MetaStoreRunConfigurationFactory
implements RunConfigurationProvider {
    public static String TYPE = "Spark";
    private SparkRunConfigurationExecutor sparkRunConfigurationExecutor;
    private List<String> supported = Arrays.asList("transformation");

    public SparkRunConfigurationProvider(MetastoreLocator metastoreLocator, SparkRunConfigurationExecutor sparkRunConfigurationExecutor) {
        super(metastoreLocator);
        this.sparkRunConfigurationExecutor = sparkRunConfigurationExecutor;
    }

    public RunConfiguration getConfiguration() {
        return new SparkRunConfiguration();
    }

    public String getType() {
        return TYPE;
    }

    protected MetaStoreFactory<SparkRunConfiguration> getMetaStoreFactory() throws MetaStoreException {
        return this.getMetastoreFactory(SparkRunConfiguration.class);
    }

    public RunConfigurationExecutor getExecutor() {
        return this.sparkRunConfigurationExecutor;
    }

    public boolean isSupported(String type) {
        return this.supported.contains(type);
    }

    public List<String> getNames(String type) {
        return this.isSupported(type) ? this.getNames() : Collections.emptyList();
    }
}

