/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.model.datatype;

import com.infobright.etl.model.datatype.AbstractColumnType;
import com.infobright.etl.model.datatype.DateType;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.GregorianCalendar;

class DateIntType
extends DateType {
    private Calendar calendar = new GregorianCalendar();

    DateIntType() {
        super("yyyy-MM-dd");
    }

    public void setData(ByteBuffer byteBuffer) throws AbstractColumnType.InvalidDataException {
        int date = byteBuffer.getInt();
        int year = 0;
        int month = 0;
        int day = 0;
        if (date > 0) {
            year = 1900 + date / 10000;
            int rem = date % 10000;
            month = rem / 100 - 1;
            day = rem % 100;
        } else if (date < 0) {
            year = 1899 - (date ^= 0xFFFFFFFF) / 10000;
            int rem = date % 10000;
            month = (9999 - rem) / 100 - 1;
            day = (9999 - rem) % 100;
        }
        this.calendar.clear();
        this.calendar.set(year, month, day);
        this.setData(this.calendar.getTime());
    }

    public void getData(ByteBuffer byteBuffer) {
        this.calendar.clear();
        this.calendar.setTime(this.getData());
        int year = this.calendar.get(1);
        int date = 0;
        if (year >= 1900) {
            int month = this.calendar.get(2) + 1;
            int day = this.calendar.get(5);
            date = (year - 1900) * 10000;
            date += month * 100;
            date += day;
        } else {
            int month = this.calendar.get(2) + 1;
            int day = this.calendar.get(5);
            date = (year - 1900) * 10000;
            date += month * 100;
            date += day;
        }
        byteBuffer.putInt(date);
    }
}

